#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 clash-ghc
version:              1.4.3
visibility:           public
id:                   clash-ghc-1.4.3-8eH0jvfngXDJzNk3QHOTSj
key:                  clash-ghc-1.4.3-8eH0jvfngXDJzNk3QHOTSj
license:              BSD-2-Clause
copyright:
    Copyright © 2012-2016, University of Twente,
    2016-2017, Myrtle Software Ltd,
    2017-2019, QBayLogic B.V., Google Inc.

maintainer:           QBayLogic B.V. <devops@qbaylogic.com>
author:               The Clash Authors
homepage:             https://clash-lang.org/
synopsis:
    Clash: a functional hardware description language - GHC frontend

description:
    Clash is a functional hardware description language that borrows both its
    syntax and semantics from the functional programming language Haskell. The
    Clash compiler transforms these high-level descriptions to low-level
    synthesizable VHDL, Verilog, or SystemVerilog.

    Features of Clash:

    * Strongly typed, but with a very high degree of type inference, enabling both
    safe and fast prototyping using concise descriptions.

    * Interactive REPL: load your designs in an interpreter and easily test all
    your component without needing to setup a test bench.

    * Higher-order functions, with type inference, result in designs that are
    fully parametric by default.

    * Synchronous sequential circuit design based on streams of values, called
    @Signal@s, lead to natural descriptions of feedback loops.

    * Support for multiple clock domains, with type safe clock domain crossing.


    This package provides:

    * Clash Compiler binary using GHC/Haskell as a frontend


    Prelude library: <https://hackage.haskell.org/package/clash-prelude>

category:             Hardware
abi:                  4332dc4361ad11be6e14da3024c58c5a
exposed:              True
exposed-modules:
    Clash.GHC.Evaluator Clash.GHC.Evaluator.Primitive
    Clash.GHC.GenerateBindings Clash.GHC.LoadModules
    Clash.GHC.NetlistTypes Clash.GHC.PartialEval
    Clash.GHC.PartialEval.Eval Clash.GHC.PartialEval.Primitive
    Clash.GHC.PartialEval.Quote Clash.GHCi.Common Clash.Main

hidden-modules:
    Clash.GHCi.UI Clash.GHCi.UI.Info Clash.GHCi.UI.Monad
    Clash.GHCi.UI.Tags Clash.GHC.ClashFlags Clash.GHC.GHC2Core
    Clash.GHC.LoadInterfaceFiles Clash.GHC.Util Paths_clash_ghc
    Clash.GHCi.Leak Clash.GHCi.Util

import-dirs:          /usr/lib/ghc-9.0.1/site-local/clash-ghc-1.4.3
library-dirs:         /usr/lib/ghc-9.0.1/site-local/clash-ghc-1.4.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/clash-ghc-1.4.3
hs-libraries:         HSclash-ghc-1.4.3-8eH0jvfngXDJzNk3QHOTSj
depends:
    Cabal-3.4.0.0 array-0.5.4.0 base-4.15.0.0
    bifunctors-5.5.11-6LpscOqvpXFF7to3ER7bDY bytestring-0.10.12.1
    clash-lib-1.4.3-HNEe8gq1irPBs8oSwiBQ4G
    clash-prelude-1.4.3-3mekPic32jVJdwPDMbo2nJ
    concurrent-supply-0.1.8-6213XVXasfr9Us9IJlTqxO containers-0.6.4.1
    deepseq-1.4.5.0 directory-1.3.6.1 exceptions-0.10.4
    extra-1.7.10-Ic4saaul5v2Abuas5lK2xt filepath-1.4.2.1 ghc-9.0.1
    ghc-bignum-1.0 ghc-boot-9.0.1 ghc-prim-0.7.0
    ghc-typelits-extra-0.4.3-9fzaSTHb1gv8J8jvt1VLqR
    ghc-typelits-knownnat-0.7.6-3zSLnciy2X5Hb8mvmLsIJP
    ghc-typelits-natnormalise-0.7.6-5PxHPFqkI6hKpa9zjBhwdw ghci-9.0.1
    hashable-1.3.4.0-IEtvls2JnYMCj5AtMjw8bF haskeline-0.8.1.0
    lens-5.0.1-E7Tul8EWHuqGCOW8gNOuPe mtl-2.2.2
    primitive-0.7.2.0-H9HP2FbaY5C1JlRHDKja9P process-1.6.11.0
    reflection-2.1.6-FWSvbImGbRh5QOUlkr4Y0U
    split-0.2.3.4-BM0SHXGG6RG9udnJVWQWWX template-haskell-2.17.0.0
    text-1.2.4.1 time-1.9.3 transformers-0.5.6.2
    uniplate-1.6.13-2uz31erAwds7VFkT8cOsFY unix-2.7.2.2
    unordered-containers-0.2.14.0-7Twq3Q78XsnAV2eREMKYwX
    utf8-string-1.0.2-FSV4F6pxd5y7PjtRkbEpDf
    vector-0.12.3.1-HMAplmdcuCN6dtD8e6QGwL

haddock-interfaces:   /usr/share/doc/clash-ghc/html/clash-ghc.haddock
haddock-html:         /usr/share/doc/clash-ghc/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

