#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 cryptol
version:              2.11.0
visibility:           public
id:                   cryptol-2.11.0-6EaNZu2zm9y9pVcc6a4fib
key:                  cryptol-2.11.0-6EaNZu2zm9y9pVcc6a4fib
license:              BSD-3-Clause
copyright:            2013-2020 Galois Inc.
maintainer:           cryptol@galois.com
author:               Galois, Inc.
homepage:             http://www.cryptol.net/
synopsis:             Cryptol: The Language of Cryptography
description:
    Cryptol is a domain-specific language for specifying cryptographic algorithms. A Cryptol implementation of an algorithm resembles its mathematical specification more closely than an implementation in a general purpose language. For more, see <http://www.cryptol.net/>.

category:             Language
abi:                  5e291d9bb4515a684b38018928cc7b19
exposed:              True
exposed-modules:
    Cryptol.AES Cryptol.Backend Cryptol.Backend.Arch
    Cryptol.Backend.Concrete Cryptol.Backend.FloatHelpers
    Cryptol.Backend.Monad Cryptol.Backend.SBV Cryptol.Backend.What4
    Cryptol.Eval Cryptol.Eval.Concrete Cryptol.Eval.Env
    Cryptol.Eval.Generic Cryptol.Eval.Prims Cryptol.Eval.Reference
    Cryptol.Eval.SBV Cryptol.Eval.Type Cryptol.Eval.Value
    Cryptol.Eval.What4 Cryptol.F2 Cryptol.IR.FreeVars
    Cryptol.ModuleSystem Cryptol.ModuleSystem.Base
    Cryptol.ModuleSystem.Env Cryptol.ModuleSystem.Exports
    Cryptol.ModuleSystem.Fingerprint
    Cryptol.ModuleSystem.InstantiateModule
    Cryptol.ModuleSystem.Interface Cryptol.ModuleSystem.Monad
    Cryptol.ModuleSystem.Name Cryptol.ModuleSystem.NamingEnv
    Cryptol.ModuleSystem.Renamer Cryptol.Parser Cryptol.Parser.AST
    Cryptol.Parser.Lexer Cryptol.Parser.Name Cryptol.Parser.Names
    Cryptol.Parser.NoInclude Cryptol.Parser.NoPat
    Cryptol.Parser.Position Cryptol.Parser.Selector
    Cryptol.Parser.Unlit Cryptol.Parser.Utils Cryptol.PrimeEC
    Cryptol.REPL.Command Cryptol.REPL.Monad Cryptol.REPL.Trie
    Cryptol.SHA Cryptol.Symbolic Cryptol.Symbolic.SBV
    Cryptol.Symbolic.What4 Cryptol.Testing.Random
    Cryptol.Transform.AddModParams Cryptol.Transform.MonoValues
    Cryptol.Transform.Specialize Cryptol.TypeCheck
    Cryptol.TypeCheck.AST Cryptol.TypeCheck.CheckModuleInstance
    Cryptol.TypeCheck.Default Cryptol.TypeCheck.Depends
    Cryptol.TypeCheck.Error Cryptol.TypeCheck.Infer
    Cryptol.TypeCheck.InferTypes Cryptol.TypeCheck.Instantiate
    Cryptol.TypeCheck.Kind Cryptol.TypeCheck.Monad Cryptol.TypeCheck.PP
    Cryptol.TypeCheck.Parseable Cryptol.TypeCheck.Sanity
    Cryptol.TypeCheck.SimpType Cryptol.TypeCheck.SimpleSolver
    Cryptol.TypeCheck.Solve Cryptol.TypeCheck.Solver.Class
    Cryptol.TypeCheck.Solver.Improve Cryptol.TypeCheck.Solver.InfNat
    Cryptol.TypeCheck.Solver.Numeric
    Cryptol.TypeCheck.Solver.Numeric.Fin
    Cryptol.TypeCheck.Solver.Numeric.Interval
    Cryptol.TypeCheck.Solver.SMT Cryptol.TypeCheck.Solver.Selector
    Cryptol.TypeCheck.Solver.Types Cryptol.TypeCheck.Solver.Utils
    Cryptol.TypeCheck.Subst Cryptol.TypeCheck.TCon
    Cryptol.TypeCheck.Type Cryptol.TypeCheck.TypeMap
    Cryptol.TypeCheck.TypeOf Cryptol.TypeCheck.TypePat
    Cryptol.TypeCheck.Unify Cryptol.Utils.Debug Cryptol.Utils.Fixity
    Cryptol.Utils.Ident Cryptol.Utils.Logger Cryptol.Utils.Misc
    Cryptol.Utils.PP Cryptol.Utils.Panic Cryptol.Utils.Patterns
    Cryptol.Utils.RecordMap Cryptol.Version

hidden-modules:
    Cryptol.Parser.LexerUtils Cryptol.Parser.ParserUtils
    Cryptol.Prelude Paths_cryptol GitRev

import-dirs:          /usr/lib/ghc-9.0.1/site-local/cryptol-2.11.0
library-dirs:         /usr/lib/ghc-9.0.1/site-local/cryptol-2.11.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/cryptol
hs-libraries:         HScryptol-2.11.0-6EaNZu2zm9y9pVcc6a4fib
depends:
    GraphSCC-1.0.4-ChnaSbhK8MS4UVqA95Pp2p
    MemoTrie-0.6.10-7QzZTpmWHatDyrvf2EWU3p
    arithmoi-0.12.0.1-4hMtk9dOAS1E4AXWtzOvcA array-0.5.4.0
    async-2.2.3-9hcO3XZAP863cAPa5inA8N base-4.15.0.0
    base-compat-0.11.2-EfuzzJ3SbjR74eBdJgKfBC
    bv-sized-1.0.3-Qaaq9X9rVcJVQmXcgRghO bytestring-0.10.12.1
    containers-0.6.4.1
    cryptohash-sha1-0.11.100.1-76A50UqL08yHXaRzujd3cE deepseq-1.4.5.0
    directory-1.3.6.1 exceptions-0.10.4 filepath-1.4.2.1 ghc-bignum-1.0
    ghc-prim-0.7.0 gitrev-1.3.1-3S5hdXPxjE4SlzdPOZm45
    heredoc-0.2.0.0-8dCyZiJbseXB5fmMncY7ZS
    libBF-0.6.2-9yTSJ06AdGw8niO3x009FQ
    monad-control-1.0.3.1-buqreaszgTDhqS64rvHY6
    monadLib-3.10-EksDn0urH2SCrBVARmWuZo mtl-2.2.2
    panic-0.4.0.1-6ICRVlNw1Qd50vb6RGATyn
    parameterized-utils-2.1.3.0-4oefTT9Pscj41668JI8m9H pretty-1.1.3.6
    process-1.6.11.0 random-1.2.1-Iy7yOfCz74T6VyvkhFUFfX
    sbv-8.16-56eoYL9C3aDAjzRfnr7k55
    simple-smt-0.9.7-DC3BXXGyjHLJd5FJMCPiis stm-2.5.0.0
    strict-0.4.0.1-1mB9RKQBFAgAU2HlDWOyE6 text-1.2.4.1
    tf-random-0.5-6wXJPjjZPxWqzySIBT0Ta time-1.9.3
    transformers-base-0.4.6-BxowhPHAvTf3506d7p3ISW
    what4-1.2.1-KVKaUj7ev1qCVmFYolnxD6

haddock-interfaces:   /usr/share/doc/cryptol/html/cryptol.haddock
haddock-html:         /usr/share/doc/cryptol/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

