#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 dhall
version:              1.40.1
visibility:           public
id:                   dhall-1.40.1-EUojmAXQXDxKxUjEQLNB2Z
key:                  dhall-1.40.1-EUojmAXQXDxKxUjEQLNB2Z
license:              BSD-3-Clause
copyright:            2017 Gabriel Gonzalez
maintainer:           Gabriel439@gmail.com
author:               Gabriel Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  5fb70da8c37da9f8c62962cf40101546
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics Dhall.Parser
    Dhall.Parser.Expression Dhall.Parser.Token Dhall.Pretty Dhall.Repl
    Dhall.Schemas Dhall.Set Dhall.Src Dhall.Substitution Dhall.TH
    Dhall.Tags Dhall.Tutorial Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.Eval Dhall.Import.Types Dhall.Marshal.Internal
    Dhall.Normalize Dhall.Parser.Combinators Dhall.Pretty.Internal
    Dhall.Syntax Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.0.1/site-local/dhall-1.40.1
library-dirs:         /usr/lib/ghc-9.0.1/site-local/dhall-1.40.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.40.1-EUojmAXQXDxKxUjEQLNB2Z
depends:
    Diff-0.4.0-F7vyJzYzam9CwrUJdg8bD2
    aeson-1.5.6.0-FZsVpvEwT8z4bK1D26EwAs
    aeson-pretty-0.8.9-4VpDxWXnDJA8Bu2hhX3Ado
    ansi-terminal-0.11-DOUngjGM5e9DBdxKKdJoVq
    atomic-write-0.2.0.7-Kd7AYNkSFsH46QJzqnspzE base-4.15.0.0
    bytestring-0.10.12.1
    case-insensitive-1.2.1.0-810KinvQcYx7xuCoSIHpwY
    cborg-0.2.5.0-BHcrZ63SqGSD7EIDfhrBUV
    cborg-json-0.2.3.0-1w3TWygEmA88GznXnvi2sb containers-0.6.4.1
    contravariant-1.5.5-1Tz7FaRP9yoKqkcBKkQ76A
    cryptonite-0.29-GRn4QfSajtp4ejYMImOiTS
    data-fix-0.3.2-3zutxYIf1gAGgK11zGPU61 deepseq-1.4.5.0
    directory-1.3.6.1 dotgen-0.4.3-D7BYbylA690EQm5UJkgmHT
    either-5.0.1.1-JgXxDVjrGuSIsFhJyaaiAe exceptions-0.10.4
    filepath-1.4.2.1 half-0.3.1-8oEQ0eXmdnKBtCQhKEjJBi
    hashable-1.3.4.0-IEtvls2JnYMCj5AtMjw8bF haskeline-0.8.1.0
    http-client-0.7.9-7wDH1vBZ53F4ywxYQ5UKER
    http-client-tls-0.3.5.3-7hBZQpnwFgt4IofGsLNJcL
    http-types-0.12.3-J3pS8fDTy4j62mHquuNqa5
    lens-family-core-2.1.0-E2lAjFxxScaCmUozZIjJxS
    megaparsec-9.2.0-LDByiSVjBO1EnZacitxvZW
    memory-0.16.0-CGaPOmXCTce28vOCDDnDFr
    mmorph-1.2.0-Ajh0k0abpSlDb3Q6HDcBvb mtl-2.2.2
    network-uri-2.6.4.1-BnEimF9gukhI4cE0Ew2RUr
    optparse-applicative-0.16.1.0-Hmp4enGFORO7G3xu1QJ5as
    parser-combinators-1.3.0-5jHqYWwdpCqFWQLuYLRvi6
    parsers-0.12.10-KaMcg7JHxkC3cA5DWkZtNc
    pretty-simple-4.0.0.0-BcM5KtwtktD4NrvOl2ufyr
    prettyprinter-1.7.1-Cr9OhaeuhZG9wS7WBggFWd
    prettyprinter-ansi-terminal-1.1.3-56brpgZIyjX2iwvXfjkCBe
    profunctors-5.6.2-JSpjDLFOHziFMPQ6l5NowS
    repline-0.4.0.0-L6GzQNG3zngJuxtUvhlgPf
    scientific-0.3.7.0-80Xt5iXHAGIBd7njyVx1yZ
    serialise-0.2.3.0-KOtEhch6SK6ZChJfJVwVo template-haskell-2.17.0.0
    text-1.2.4.1 text-manipulate-0.3.0.0-CI11LK5ACPtCDkRBP2JlIo
    th-lift-instances-0.1.18-D8xbmf4aEv7KKE6pjHfR6K time-1.9.3
    transformers-0.5.6.2
    unordered-containers-0.2.14.0-7Twq3Q78XsnAV2eREMKYwX
    uri-encode-1.5.0.7-K9j714YHKkkIof8vuvZsab
    vector-0.12.3.1-HMAplmdcuCN6dtD8e6QGwL

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

