#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 aeson-pretty
version:              0.8.9
visibility:           public
id:                   aeson-pretty-0.8.9-4VpDxWXnDJA8Bu2hhX3Ado
key:                  aeson-pretty-0.8.9-4VpDxWXnDJA8Bu2hhX3Ado
license:              BSD-3-Clause
copyright:            Copyright 2011 Falko Peters
maintainer:           Martijn Bastiaan <martijn@hmbastiaan.nl>
author:               Falko Peters <falko.peters@gmail.com>
stability:            experimental
homepage:             http://github.com/informatikr/aeson-pretty
synopsis:             JSON pretty-printing library and command-line tool.
description:
    A JSON pretty-printing library compatible with aeson as well as
    a command-line tool to improve readabilty of streams of JSON data.

    The /library/ provides the function "encodePretty". It is a drop-in
    replacement for aeson'\''s "encode" function, producing JSON-ByteStrings for
    human readers.

    The /command-line tool/ reads JSON from stdin and writes prettified JSON
    to stdout. It also offers a complementary "compact"-mode, essentially the
    opposite of pretty-printing. If you specify @-flib-only@ like this

    > cabal install -flib-only aeson-pretty

    the command-line tool will NOT be installed.

category:             Text, Web, JSON, Pretty Printer
abi:                  9743b7eae062681d5a4e6188d47aad34
exposed:              True
exposed-modules:      Data.Aeson.Encode.Pretty
import-dirs:          /usr/lib/ghc-9.0.1/site-local/aeson-pretty-0.8.9
library-dirs:         /usr/lib/ghc-9.0.1/site-local/aeson-pretty-0.8.9
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/aeson-pretty-0.8.9
hs-libraries:         HSaeson-pretty-0.8.9-4VpDxWXnDJA8Bu2hhX3Ado
depends:
    aeson-1.5.6.0-FZsVpvEwT8z4bK1D26EwAs base-4.15.0.0
    base-compat-0.11.2-EfuzzJ3SbjR74eBdJgKfBC bytestring-0.10.12.1
    scientific-0.3.7.0-80Xt5iXHAGIBd7njyVx1yZ text-1.2.4.1
    unordered-containers-0.2.14.0-7Twq3Q78XsnAV2eREMKYwX
    vector-0.12.3.1-HMAplmdcuCN6dtD8e6QGwL

haddock-interfaces:
    /usr/share/doc/haskell-aeson-pretty/html/aeson-pretty.haddock

haddock-html:         /usr/share/doc/haskell-aeson-pretty/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

