#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 arithmoi
version:              0.12.0.1
visibility:           public
id:                   arithmoi-0.12.0.1-4hMtk9dOAS1E4AXWtzOvcA
key:                  arithmoi-0.12.0.1-4hMtk9dOAS1E4AXWtzOvcA
license:              MIT
copyright:
    (c) 2016-2021 Andrew Lelechenko, 2016-2019 Carter Schonwald, 2011 Daniel Fischer

maintainer:           Andrew Lelechenko <andrew.lelechenko@gmail.com>
author:               Andrew Lelechenko, Daniel Fischer
homepage:             https://github.com/Bodigrim/arithmoi
synopsis:             Efficient basic number-theoretic functions.
description:
    A library of basic functionality needed for
    number-theoretic calculations. The aim of this library
    is to provide efficient implementations of the functions.
    Primes and related things (totients, factorisation),
    powers (integer roots and tests, modular exponentiation).

category:             Math, Algorithms, Number Theory
abi:                  2a597615a0eb7479c182b547d8888ebf
exposed:              True
exposed-modules:
    Math.NumberTheory.ArithmeticFunctions
    Math.NumberTheory.ArithmeticFunctions.Inverse
    Math.NumberTheory.ArithmeticFunctions.Mertens
    Math.NumberTheory.ArithmeticFunctions.Moebius
    Math.NumberTheory.ArithmeticFunctions.NFreedom
    Math.NumberTheory.ArithmeticFunctions.SieveBlock
    Math.NumberTheory.Curves.Montgomery Math.NumberTheory.Diophantine
    Math.NumberTheory.DirichletCharacters
    Math.NumberTheory.Euclidean.Coprimes Math.NumberTheory.Moduli
    Math.NumberTheory.Moduli.Cbrt Math.NumberTheory.Moduli.Chinese
    Math.NumberTheory.Moduli.Class Math.NumberTheory.Moduli.Equations
    Math.NumberTheory.Moduli.Multiplicative
    Math.NumberTheory.Moduli.Singleton Math.NumberTheory.Moduli.Sqrt
    Math.NumberTheory.MoebiusInversion Math.NumberTheory.Powers.Modular
    Math.NumberTheory.Prefactored Math.NumberTheory.Primes
    Math.NumberTheory.Primes.Counting Math.NumberTheory.Primes.IntSet
    Math.NumberTheory.Primes.Testing
    Math.NumberTheory.Quadratic.EisensteinIntegers
    Math.NumberTheory.Quadratic.GaussianIntegers
    Math.NumberTheory.Recurrences
    Math.NumberTheory.Recurrences.Bilinear
    Math.NumberTheory.Recurrences.Linear
    Math.NumberTheory.SmoothNumbers Math.NumberTheory.Zeta

hidden-modules:
    Math.NumberTheory.ArithmeticFunctions.Class
    Math.NumberTheory.ArithmeticFunctions.Standard
    Math.NumberTheory.Moduli.Internal
    Math.NumberTheory.Moduli.JacobiSymbol
    Math.NumberTheory.Moduli.SomeMod
    Math.NumberTheory.Primes.Counting.Approximate
    Math.NumberTheory.Primes.Counting.Impl
    Math.NumberTheory.Primes.Factorisation.Montgomery
    Math.NumberTheory.Primes.Factorisation.TrialDivision
    Math.NumberTheory.Primes.Sieve.Eratosthenes
    Math.NumberTheory.Primes.Sieve.Indexing
    Math.NumberTheory.Primes.Small
    Math.NumberTheory.Primes.Testing.Certified
    Math.NumberTheory.Primes.Testing.Probabilistic
    Math.NumberTheory.Primes.Types
    Math.NumberTheory.Recurrences.Pentagonal
    Math.NumberTheory.RootsOfUnity Math.NumberTheory.Utils
    Math.NumberTheory.Utils.DirichletSeries
    Math.NumberTheory.Utils.FromIntegral
    Math.NumberTheory.Utils.Hyperbola Math.NumberTheory.Zeta.Dirichlet
    Math.NumberTheory.Zeta.Hurwitz Math.NumberTheory.Zeta.Riemann
    Math.NumberTheory.Zeta.Utils

import-dirs:          /usr/lib/ghc-9.0.1/site-local/arithmoi-0.12.0.1
library-dirs:         /usr/lib/ghc-9.0.1/site-local/arithmoi-0.12.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/arithmoi-0.12.0.1
hs-libraries:         HSarithmoi-0.12.0.1-4hMtk9dOAS1E4AXWtzOvcA
depends:
    array-0.5.4.0 base-4.15.0.0 chimera-0.3.2.0-IFEXEh5vX4e2jP5BY2Ycco
    constraints-0.13-7MWFMqEXLyNHc3bFX4nznn containers-0.6.4.1
    deepseq-1.4.5.0 exact-pi-0.5.0.1-EISMHxl50YKCvHq2gix9bQ
    integer-gmp-1.1 integer-logarithms-1.0.3.1-2aDPDo9uecRBlUQZ3qjecW
    integer-roots-1.0.0.1-2ESdYrK89nCLSPiCpZs1Zw
    mod-0.1.2.2-4pjEZPe33DS73FvaKf35Ya
    random-1.2.1-Iy7yOfCz74T6VyvkhFUFfX
    semirings-0.6-2KIhyGdincC3T3R8liKfc3 transformers-0.5.6.2
    vector-0.12.3.1-HMAplmdcuCN6dtD8e6QGwL

haddock-interfaces:   /usr/share/doc/haskell-arithmoi/html/arithmoi.haddock
haddock-html:         /usr/share/doc/haskell-arithmoi/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

