#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 async
version:              2.2.3
visibility:           public
id:                   async-2.2.3-9hcO3XZAP863cAPa5inA8N
key:                  async-2.2.3-9hcO3XZAP863cAPa5inA8N
license:              BSD-3-Clause
copyright:            (c) Simon Marlow 2012
maintainer:           Simon Marlow <marlowsd@gmail.com>
author:               Simon Marlow
homepage:             https://github.com/simonmar/async
synopsis:             Run IO operations asynchronously and wait for their results
description:
    This package provides a higher-level interface over
    threads, in which an @Async a@ is a concurrent
    thread that will eventually deliver a value of
    type @a@.  The package provides ways to create
    @Async@ computations, wait for their results, and
    cancel them.

    Using @Async@ is safer than using threads in two
    ways:

    * When waiting for a thread to return a result,
    if the thread dies with an exception then the
    caller must either re-throw the exception
    ('\''wait'\'') or handle it ('\''waitCatch'\''); the
    exception cannot be ignored.

    * The API makes it possible to build a tree of
    threads that are automatically killed when
    their parent dies (see '\''withAsync'\'').

category:             Concurrency
abi:                  f5e52b5595d46465797c70757e950013
exposed:              True
exposed-modules:      Control.Concurrent.Async
import-dirs:          /usr/lib/ghc-9.0.1/site-local/async-2.2.3
library-dirs:         /usr/lib/ghc-9.0.1/site-local/async-2.2.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/async-2.2.3
hs-libraries:         HSasync-2.2.3-9hcO3XZAP863cAPa5inA8N
depends:
    base-4.15.0.0 hashable-1.3.4.0-IEtvls2JnYMCj5AtMjw8bF stm-2.5.0.0

haddock-interfaces:   /usr/share/doc/haskell-async/html/async.haddock
haddock-html:         /usr/share/doc/haskell-async/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

