#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 atomic-primops
version:              0.8.4
visibility:           public
id:                   atomic-primops-0.8.4-8JQZEtLH3F017jGUEWGfE6
key:                  atomic-primops-0.8.4-8JQZEtLH3F017jGUEWGfE6
license:              BSD-3-Clause
maintainer:           rrnewton@gmail.com
author:               Ryan Newton
homepage:             https://github.com/rrnewton/haskell-lockfree/wiki
synopsis:             A safe approach to CAS and other atomic ops in Haskell.
description:
    After GHC 7.4 a new `casMutVar#` primop became available, but it'\''s
    difficult to use safely, because pointer equality is a highly
    unstable property in Haskell.  This library provides a safer method
    based on the concept of "Tickets".

    Also, this library uses the "foreign primop" capability of GHC to
    add access to other variants that may be of
    interest, specifically, compare and swap inside an array.

    Note that as of GHC 7.8, the relevant primops have been included in GHC itself.
    This library is engineered to work pre- and post-GHC-7.8, while exposing the
    same interface.

category:             Data
abi:                  6835dfb90cb1d1e719092c63d290c47f
exposed:              True
exposed-modules:
    Data.Atomics Data.Atomics.Counter Data.Atomics.Internal

import-dirs:          /usr/lib/ghc-9.0.1/site-local/atomic-primops-0.8.4
library-dirs:         /usr/lib/ghc-9.0.1/site-local/atomic-primops-0.8.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/atomic-primops-0.8.4
hs-libraries:         HSatomic-primops-0.8.4-8JQZEtLH3F017jGUEWGfE6
depends:
    base-4.15.0.0 ghc-prim-0.7.0
    primitive-0.7.2.0-H9HP2FbaY5C1JlRHDKja9P

haddock-interfaces:
    /usr/share/doc/haskell-atomic-primops/html/atomic-primops.haddock

haddock-html:         /usr/share/doc/haskell-atomic-primops/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

