#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 atomic-write
version:              0.2.0.7
visibility:           public
id:                   atomic-write-0.2.0.7-Kd7AYNkSFsH46QJzqnspzE
key:                  atomic-write-0.2.0.7-Kd7AYNkSFsH46QJzqnspzE
license:              MIT
copyright:            2015-2019 Stack Builders Inc.
maintainer:           support@stackbuilders.com
author:               Justin Leitgeb
homepage:             https://github.com/stackbuilders/atomic-write
synopsis:             Atomically write to a file
description:

    Atomically write to a file on POSIX-compliant systems while preserving
    permissions.

    On most Unix systems, `mv` is an atomic operation. This makes it simple to write
    to a file atomically just by using the mv operation. However, this will
    destroy the permissions on the original file. This library does the following
    to preserve permissions while atomically writing to a file:

    * If an original file exists, take those permissions and apply them to the
    temp file before `mv`ing the file into place.

    * If the original file does not exist, create a following with default
    permissions (based on the currently-active umask).

    This way, when the file is `mv`'\''ed into place, the permissions will be the ones
    held by the original file.

    This library is based on similar implementations found in common libraries in
    Ruby and Python:

    * <http://apidock.com/rails/File/atomic_write/class Ruby on Rails includes a similar method called atomic_write>

    * <https://github.com/chef/chef/blob/c4631816132fcfefaba3d123a1d0dfe8bc2866bb/lib/chef/file_content_management/deploy/mv_unix.rb#L23:L71 Chef includes atomic update functionality>

    * <https://github.com/sashka/atomicfile There is a python library for atomically updating a file>

    To use `atomic-write`, import the module corresponding to the type you wish to
    write atomically, e.g., to write a (strict) ByteString atomically:

    > import System.AtomicWrite.Writer.ByteString

    Then you can use the atomicWriteFile function that accepts a `FilePath` and a
    `ByteString`, e.g.:

    > atomicWriteFile myFilePath myByteString

category:             System
abi:                  c4a4a6ed84543c687be33ef3192e1b0f
exposed:              True
exposed-modules:
    System.AtomicWrite.Writer.ByteString
    System.AtomicWrite.Writer.ByteString.Binary
    System.AtomicWrite.Writer.ByteStringBuilder
    System.AtomicWrite.Writer.LazyByteString
    System.AtomicWrite.Writer.LazyByteString.Binary
    System.AtomicWrite.Writer.LazyText
    System.AtomicWrite.Writer.LazyText.Binary
    System.AtomicWrite.Writer.String
    System.AtomicWrite.Writer.String.Binary
    System.AtomicWrite.Writer.Text
    System.AtomicWrite.Writer.Text.Binary

hidden-modules:       System.AtomicWrite.Internal
import-dirs:          /usr/lib/ghc-9.0.1/site-local/atomic-write-0.2.0.7
library-dirs:         /usr/lib/ghc-9.0.1/site-local/atomic-write-0.2.0.7
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/atomic-write-0.2.0.7
hs-libraries:         HSatomic-write-0.2.0.7-Kd7AYNkSFsH46QJzqnspzE
depends:
    base-4.15.0.0 bytestring-0.10.12.1 directory-1.3.6.1
    filepath-1.4.2.1 temporary-1.3-6FIxg0ZrJD07j9FbKd9D73 text-1.2.4.1
    unix-compat-0.5.3-CsWJk3UHZrh7lbWn5tdOhn

haddock-interfaces:
    /usr/share/doc/haskell-atomic-write/html/atomic-write.haddock

haddock-html:         /usr/share/doc/haskell-atomic-write/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

