#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 brick
version:              0.64.1
visibility:           public
id:                   brick-0.64.1-AHVRMs1QGOnDjIukrKMlv7
key:                  brick-0.64.1-AHVRMs1QGOnDjIukrKMlv7
license:              BSD-3-Clause
copyright:            (c) Jonathan Daugherty 2015-2020
maintainer:           Jonathan Daugherty <cygnus@foobox.com>
author:               Jonathan Daugherty <cygnus@foobox.com>
homepage:             https://github.com/jtdaugherty/brick/
synopsis:             A declarative terminal user interface library
description:
    Write terminal user interfaces (TUIs) painlessly with '\''brick'\''! You
    write an event handler and a drawing function and the library does the
    rest.


    > module Main where
    >
    > import Brick
    >
    > ui :: Widget ()
    > ui = str "Hello, world!"
    >
    > main :: IO ()
    > main = simpleMain ui


    To get started, see:

    * <https://github.com/jtdaugherty/brick/blob/master/README.md The README>

    * The <https://github.com/jtdaugherty/brick/blob/master/docs/guide.rst Brick user guide>

    * The demonstration programs in the '\''programs'\'' directory


    This package deprecates <http://hackage.haskell.org/package/vty-ui vty-ui>.

category:             Graphics
abi:                  2f1f674c6e3d88813184ea4ee2a498e3
exposed:              True
exposed-modules:
    Brick Brick.AttrMap Brick.BChan Brick.BorderMap Brick.Focus
    Brick.Forms Brick.Main Brick.Markup Brick.Themes Brick.Types
    Brick.Util Brick.Widgets.Border Brick.Widgets.Border.Style
    Brick.Widgets.Center Brick.Widgets.Core Brick.Widgets.Dialog
    Brick.Widgets.Edit Brick.Widgets.FileBrowser Brick.Widgets.List
    Brick.Widgets.ProgressBar Brick.Widgets.Table Data.IMap
    Data.Text.Markup

hidden-modules:
    Brick.Types.Common Brick.Types.TH Brick.Types.Internal
    Brick.Widgets.Internal

import-dirs:          /usr/lib/ghc-9.0.1/site-local/brick-0.64.1
library-dirs:         /usr/lib/ghc-9.0.1/site-local/brick-0.64.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/brick-0.64.1
hs-libraries:         HSbrick-0.64.1-AHVRMs1QGOnDjIukrKMlv7
depends:
    base-4.15.0.0 bytestring-0.10.12.1
    config-ini-0.2.4.0-JqMxLGwfDCs7uHffW4cbiq containers-0.6.4.1
    contravariant-1.5.5-1Tz7FaRP9yoKqkcBKkQ76A
    data-clist-0.1.2.3-FKrY7rEY7hDD4ZlvJhoPzT deepseq-1.4.5.0
    directory-1.3.6.1 dlist-1.0-DqtNBE1aXOzH1lBPsXifRQ
    exceptions-0.10.4 filepath-1.4.2.1
    microlens-0.4.12.0-IoK2ncpVKVzEwRUasmz5D3
    microlens-mtl-0.2.0.1-FtqdtT70ljXCaWrzLLs7rg
    microlens-th-0.4.3.10-D8A4jvR3QXlLLaZkQUchH1 stm-2.5.0.0
    template-haskell-2.17.0.0 text-1.2.4.1
    text-zipper-0.11-IZr6MXTInNn3kdugrbiTZF transformers-0.5.6.2
    unix-2.7.2.2 vector-0.12.3.1-HMAplmdcuCN6dtD8e6QGwL
    vty-5.33-4dyGEgT6Ey481JD116mwMg
    word-wrap-0.5-97ktFeb2hUaDYBbrwXVr8f

haddock-interfaces:   /usr/share/doc/haskell-brick/html/brick.haddock
haddock-html:         /usr/share/doc/haskell-brick/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

