#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 chimera
version:              0.3.2.0
visibility:           public
id:                   chimera-0.3.2.0-IFEXEh5vX4e2jP5BY2Ycco
key:                  chimera-0.3.2.0-IFEXEh5vX4e2jP5BY2Ycco
license:              BSD-3-Clause
copyright:            2017-2019 Bodigrim
maintainer:           andrew.lelechenko@gmail.com
author:               Bodigrim
homepage:             https://github.com/Bodigrim/chimera#readme
synopsis:
    Lazy infinite streams with O(1) indexing and applications for memoization

description:
    There are plenty of memoizing libraries on Hackage, but they
    usually fall into two categories:

    * Store cache as a flat array, enabling us
    to obtain cached values in O(1) time, which is nice.
    The drawback is that one must specify the size
    of the array beforehand,
    limiting an interval of inputs,
    and actually allocate it at once.
    * Store cache as a lazy binary tree.
    Thanks to laziness, one can freely use the full range of inputs.
    The drawback is that obtaining values from a tree
    takes logarithmic time and is unfriendly to CPU cache,
    which kinda defeats the purpose.

    This package intends to tackle both issues,
    providing a data type '\''Chimera'\'' for
    lazy infinite compact streams with cache-friendly O(1) indexing.

    Additional features include:

    * memoization of recursive functions and recurrent sequences,
    * memoization of functions of several, possibly signed arguments,
    * efficient memoization of boolean predicates.

category:             Data
abi:                  8c4001aca7dd0e669d081fb84d47ccb8
exposed:              True
exposed-modules:
    Data.Chimera Data.Chimera.ContinuousMapping
    Data.Chimera.WheelMapping

hidden-modules:       Data.Chimera.Compat Data.Chimera.FromIntegral
import-dirs:          /usr/lib/ghc-9.0.1/site-local/chimera-0.3.2.0
library-dirs:         /usr/lib/ghc-9.0.1/site-local/chimera-0.3.2.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/chimera-0.3.2.0
hs-libraries:         HSchimera-0.3.2.0-IFEXEh5vX4e2jP5BY2Ycco
depends:
    adjunctions-4.4-FNkzYDnZkAqYPNKnfdzCn base-4.15.0.0
    distributive-0.6.2.1-L3Ykidc02co43xZ4dEYAPL mtl-2.2.2
    vector-0.12.3.1-HMAplmdcuCN6dtD8e6QGwL

haddock-interfaces:   /usr/share/doc/haskell-chimera/html/chimera.haddock
haddock-html:         /usr/share/doc/haskell-chimera/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

