#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 clash-lib
version:              1.4.3
visibility:           public
id:                   clash-lib-1.4.3-HNEe8gq1irPBs8oSwiBQ4G
key:                  clash-lib-1.4.3-HNEe8gq1irPBs8oSwiBQ4G
license:              BSD-2-Clause
copyright:
    Copyright © 2012-2016, University of Twente,
    2016-2019, Myrtle Software Ltd,
    2017-2019, QBayLogic B.V., Google Inc.

maintainer:           QBayLogic B.V. <devops@qbaylogic.com>
author:               The Clash Authors
homepage:             https://clash-lang.org/
synopsis:
    Clash: a functional hardware description language - As a library

description:
    Clash is a functional hardware description language that borrows both its
    syntax and semantics from the functional programming language Haskell. The
    Clash compiler transforms these high-level descriptions to low-level
    synthesizable VHDL, Verilog, or SystemVerilog.

    Features of Clash:

    * Strongly typed, but with a very high degree of type inference, enabling both
    safe and fast prototyping using concise descriptions.

    * Interactive REPL: load your designs in an interpreter and easily test all
    your component without needing to setup a test bench.

    * Higher-order functions, with type inference, result in designs that are
    fully parametric by default.

    * Synchronous sequential circuit design based on streams of values, called
    @Signal@s, lead to natural descriptions of feedback loops.

    * Support for multiple clock domains, with type safe clock domain crossing.


    This package provides:

    * The CoreHW internal language: SystemF + Letrec + Case-decomposition

    * The normalisation process that brings CoreHW in a normal form that can be
    converted to a netlist

    * Blackbox/Primitive Handling


    Front-ends (for: parsing, typecheck, etc.) are provided by separate packages:

    * <https://hackage.haskell.org/package/clash-ghc GHC/Haskell Frontend>

    * <https://github.com/christiaanb/Idris-dev Idris Frontend>


    Prelude library: <https://hackage.haskell.org/package/clash-prelude>

category:             Hardware
abi:                  10600d96996cd252648a365b7c2e05af
exposed:              True
exposed-modules:
    Clash.Annotations.BitRepresentation.ClashLib Clash.Backend
    Clash.Backend.SystemVerilog Clash.Backend.VHDL
    Clash.Backend.Verilog Clash.Core.DataCon Clash.Core.EqSolver
    Clash.Core.Evaluator.Types Clash.Core.FreeVars Clash.Core.Literal
    Clash.Core.Name Clash.Core.PartialEval
    Clash.Core.PartialEval.AsTerm Clash.Core.PartialEval.Monad
    Clash.Core.PartialEval.NormalForm Clash.Core.Pretty
    Clash.Core.Subst Clash.Core.Term Clash.Core.TermInfo
    Clash.Core.TermLiteral Clash.Core.TermLiteral.TH
    Clash.Core.Termination Clash.Core.TyCon Clash.Core.Type
    Clash.Core.TysPrim Clash.Core.Util Clash.Core.Var Clash.Core.VarEnv
    Clash.Debug Clash.Driver Clash.Driver.Manifest Clash.Driver.Types
    Clash.Edalize.Edam Clash.Netlist Clash.Netlist.BlackBox
    Clash.Netlist.BlackBox.Parser Clash.Netlist.BlackBox.Types
    Clash.Netlist.BlackBox.Util Clash.Netlist.Id
    Clash.Netlist.Id.Common Clash.Netlist.Id.Internal
    Clash.Netlist.Id.SystemVerilog Clash.Netlist.Id.VHDL
    Clash.Netlist.Id.Verilog Clash.Netlist.Types Clash.Netlist.Util
    Clash.Normalize Clash.Normalize.DEC
    Clash.Normalize.PrimitiveReductions Clash.Normalize.Strategy
    Clash.Normalize.Transformations Clash.Normalize.Types
    Clash.Normalize.Util Clash.Pretty Clash.Primitives.DSL
    Clash.Primitives.GHC.Int Clash.Primitives.GHC.Literal
    Clash.Primitives.GHC.Word Clash.Primitives.Intel.ClockGen
    Clash.Primitives.Sized.ToInteger Clash.Primitives.Sized.Vector
    Clash.Primitives.Types Clash.Primitives.Util
    Clash.Primitives.Verification Clash.Rewrite.Combinators
    Clash.Rewrite.Types Clash.Rewrite.Util Clash.Rewrite.WorkFree
    Clash.Unique Clash.Util Clash.Util.Graph Clash.Util.Interpolate
    Data.Text.Prettyprint.Doc.Extra

hidden-modules:
    Clash.Annotations.TopEntity.Extra Control.Applicative.Extra
    Data.Aeson.Extra Data.List.Extra Data.Map.Ordered.Extra
    Data.Primitive.ByteArray.Extra Data.Semigroup.Monad.Extra
    Data.Set.Ordered.Extra GHC.BasicTypes.Extra GHC.SrcLoc.Extra
    Paths_clash_lib

import-dirs:          /usr/lib/ghc-9.0.1/site-local/clash-lib-1.4.3
library-dirs:         /usr/lib/ghc-9.0.1/site-local/clash-lib-1.4.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/clash-lib-1.4.3
hs-libraries:         HSclash-lib-1.4.3-HNEe8gq1irPBs8oSwiBQ4G
depends:
    aeson-1.5.6.0-FZsVpvEwT8z4bK1D26EwAs
    aeson-pretty-0.8.9-4VpDxWXnDJA8Bu2hhX3Ado
    ansi-terminal-0.11-DOUngjGM5e9DBdxKKdJoVq array-0.5.4.0
    attoparsec-0.14.1-B8P567zH1pOF107V9enGUK base-4.15.0.0
    base16-bytestring-1.0.1.0-ACUewSgXa2lGPxnToJIotQ binary-0.8.8.0
    bytestring-0.10.12.1 clash-prelude-1.4.3-3mekPic32jVJdwPDMbo2nJ
    concurrent-supply-0.1.8-6213XVXasfr9Us9IJlTqxO containers-0.6.4.1
    cryptohash-sha256-0.11.102.1-9vt4wQqgpeCLI96cwNF4nv
    data-binary-ieee754-0.4.4-1uzt85nFoxu5Mgq2DE5oph
    data-default-0.7.1.1-5RJjHNv19ESJeD93LU2jRn deepseq-1.4.5.0
    directory-1.3.6.1 dlist-1.0-DqtNBE1aXOzH1lBPsXifRQ
    errors-2.3.0-FhBmHY7sMIf8wTT2E4ozOx exceptions-0.10.4
    extra-1.7.10-Ic4saaul5v2Abuas5lK2xt filepath-1.4.2.1 ghc-9.0.1
    ghc-bignum-1.0 ghc-boot-th-9.0.1
    hashable-1.3.4.0-IEtvls2JnYMCj5AtMjw8bF
    haskell-src-meta-0.8.7-I1BJVlGBmDa5HEpVEckc80
    hint-0.9.0.4-Ia0LIB48wpY62b02NU4Zg5
    interpolate-0.2.1-CTRFeNQR0JH2n3wiMdvtgn
    lens-5.0.1-E7Tul8EWHuqGCOW8gNOuPe mtl-2.2.2
    ordered-containers-0.2.2-HFNNhie1Aw64sPyEbOR86d
    parsers-0.12.10-KaMcg7JHxkC3cA5DWkZtNc
    pretty-show-1.10-G4SfLXvOfw8HasEUHDrqxD
    prettyprinter-1.7.1-Cr9OhaeuhZG9wS7WBggFWd
    primitive-0.7.2.0-H9HP2FbaY5C1JlRHDKja9P process-1.6.11.0
    reducers-3.12.4-FtD3hvrJhaj6SpIodnf5u1 template-haskell-2.17.0.0
    temporary-1.3-6FIxg0ZrJD07j9FbKd9D73
    terminal-size-0.3.2.1-8rLUbNor4uN6iQgtxjW6lw text-1.2.4.1
    text-show-3.9.1-FaZHv6PA3Sy8N2jVQFERyA time-1.9.3
    transformers-0.5.6.2 trifecta-2.1.1-AqfihMPjaSeAZQt2J0vbZG
    unordered-containers-0.2.14.0-7Twq3Q78XsnAV2eREMKYwX
    utf8-string-1.0.2-FSV4F6pxd5y7PjtRkbEpDf
    vector-0.12.3.1-HMAplmdcuCN6dtD8e6QGwL
    vector-binary-instances-0.2.5.2-20zf7Gm3C4DADIkedFqC2R

haddock-interfaces:   /usr/share/doc/haskell-clash-lib/html/clash-lib.haddock
haddock-html:         /usr/share/doc/haskell-clash-lib/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

