#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 conduit
version:              1.3.4.2
visibility:           public
id:                   conduit-1.3.4.2-G1HkDA3DXNW8qvzQqLFdeJ
key:                  conduit-1.3.4.2-G1HkDA3DXNW8qvzQqLFdeJ
license:              MIT
maintainer:           michael@snoyman.com
author:               Michael Snoyman
homepage:             http://github.com/snoyberg/conduit
synopsis:             Streaming data processing library.
description:
    `conduit` is a solution to the streaming data problem, allowing for production,
    transformation, and consumption of streams of data in constant memory. It is an
    alternative to lazy I\/O which guarantees deterministic resource handling.

    For more information about conduit in general, and how this package in
    particular fits into the ecosystem, see [the conduit
    homepage](https://github.com/snoyberg/conduit#readme).

    Hackage documentation generation is not reliable. For up to date documentation, please see: <http://www.stackage.org/package/conduit>.

category:             Data, Conduit
abi:                  65740aaebb496353b161fe3fcf587e97
exposed:              True
exposed-modules:
    Conduit Data.Conduit Data.Conduit.Combinators
    Data.Conduit.Combinators.Stream Data.Conduit.Internal
    Data.Conduit.Internal.Fusion Data.Conduit.Internal.List.Stream
    Data.Conduit.Lift Data.Conduit.List

hidden-modules:
    Data.Conduit.Internal.Pipe Data.Conduit.Internal.Conduit
    Data.Conduit.Combinators.Unqualified Data.Streaming.FileRead
    Data.Streaming.Filesystem

import-dirs:          /usr/lib/ghc-9.0.1/site-local/conduit-1.3.4.2
library-dirs:         /usr/lib/ghc-9.0.1/site-local/conduit-1.3.4.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/conduit-1.3.4.2
hs-libraries:         HSconduit-1.3.4.2-G1HkDA3DXNW8qvzQqLFdeJ
depends:
    base-4.15.0.0 bytestring-0.10.12.1 directory-1.3.6.1
    exceptions-0.10.4 filepath-1.4.2.1
    mono-traversable-1.0.15.3-Bb3okSZSbJE5qOTbvHMKHA mtl-2.2.2
    primitive-0.7.2.0-H9HP2FbaY5C1JlRHDKja9P
    resourcet-1.2.4.3-8689t6OWpHGD0T1pI8fpT0 text-1.2.4.1
    transformers-0.5.6.2 unix-2.7.2.2
    unliftio-core-0.2.0.1-2baD1vXgUkB5a1NRn2rSLN
    vector-0.12.3.1-HMAplmdcuCN6dtD8e6QGwL

haddock-interfaces:   /usr/share/doc/haskell-conduit/html/conduit.haddock
haddock-html:         /usr/share/doc/haskell-conduit/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

