#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 config-ini
version:              0.2.4.0
visibility:           public
id:                   config-ini-0.2.4.0-JqMxLGwfDCs7uHffW4cbiq
key:                  config-ini-0.2.4.0-JqMxLGwfDCs7uHffW4cbiq
license:              BSD-3-Clause
copyright:            ©2018 Getty Ritter
maintainer:           Getty Ritter <config-ini@infinitenegativeutility.com>
author:               Getty Ritter <config-ini@infinitenegativeutility.com>
homepage:             https://github.com/aisamanra/config-ini
synopsis:             A library for simple INI-based configuration files.
description:
    The @config-ini@ library is a set of small monadic languages
    for writing simple configuration languages with convenient,
    human-readable error messages.

    > parseConfig :: IniParser (Text, Int, Bool)
    > parseConfig = section "NETWORK" $ do
    >   user <- field        "user"
    >   port <- fieldOf      "port" number
    >   enc  <- fieldFlagDef "encryption" True
    >   return (user, port, enc)

category:             Configuration
abi:                  def279ef1ae351157cf2f42f1efafcc8
exposed:              True
exposed-modules:
    Data.Ini.Config Data.Ini.Config.Bidir Data.Ini.Config.Raw

import-dirs:          /usr/lib/ghc-9.0.1/site-local/config-ini-0.2.4.0
library-dirs:         /usr/lib/ghc-9.0.1/site-local/config-ini-0.2.4.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/config-ini-0.2.4.0
hs-libraries:         HSconfig-ini-0.2.4.0-JqMxLGwfDCs7uHffW4cbiq
depends:
    base-4.15.0.0 containers-0.6.4.1
    megaparsec-9.2.0-LDByiSVjBO1EnZacitxvZW text-1.2.4.1
    transformers-0.5.6.2
    unordered-containers-0.2.14.0-7Twq3Q78XsnAV2eREMKYwX

haddock-interfaces:   /usr/share/doc/haskell-config-ini/html/config-ini.haddock
haddock-html:         /usr/share/doc/haskell-config-ini/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

