#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 dependent-sum
version:              0.7.1.0
visibility:           public
id:                   dependent-sum-0.7.1.0-DIrhf2psIrCJabLI7f0L8O
key:                  dependent-sum-0.7.1.0-DIrhf2psIrCJabLI7f0L8O
license:              LicenseRef-PublicDomain
maintainer:           Obsidian Systems, LLC <maintainer@obsidian.systems>
author:               James Cook <mokus@deepbondi.net>
stability:            provisional
homepage:             https://github.com/obsidiansystems/dependent-sum
synopsis:             Dependent sum type
description:
    A dependent sum is a generalization of a
    particular way of thinking about the @Either@
    type.  @Either a b@ can be thought of as a
    2-tuple @(tag, value)@, where the value of the
    tag determines the type of the value.  In
    particular, either @tag = Left@ and @value :: a@
    or @tag = Right@ and @value :: b@.

    This package allows you to define your own
    dependent sum types by using your own \"tag\"
    types.

category:             Data, Dependent Types
abi:                  09f66cae7564f937bd9830326ae857aa
exposed:              True
exposed-modules:
    Data.Dependent.Sum,
    Data.GADT.Compare from some-1.0.3-7sghqqTkEQg7XqQ206Tg1F:Data.GADT.Compare,
    Data.GADT.Show from some-1.0.3-7sghqqTkEQg7XqQ206Tg1F:Data.GADT.Show,
    Data.Some from some-1.0.3-7sghqqTkEQg7XqQ206Tg1F:Data.Some

import-dirs:          /usr/lib/ghc-9.0.1/site-local/dependent-sum-0.7.1.0
library-dirs:         /usr/lib/ghc-9.0.1/site-local/dependent-sum-0.7.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/dependent-sum-0.7.1.0
hs-libraries:         HSdependent-sum-0.7.1.0-DIrhf2psIrCJabLI7f0L8O
depends:
    base-4.15.0.0 constraints-extras-0.3.1.0-FEcTjooMp0D6au2zN8rXqx
    some-1.0.3-7sghqqTkEQg7XqQ206Tg1F

haddock-interfaces:
    /usr/share/doc/haskell-dependent-sum/html/dependent-sum.haddock

haddock-html:         /usr/share/doc/haskell-dependent-sum/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

