#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 feed
version:              1.3.2.0
visibility:           public
id:                   feed-1.3.2.0-AvcCruj4zHFAH4qSaQaXSt
key:                  feed-1.3.2.0-AvcCruj4zHFAH4qSaQaXSt
license:              BSD-3-Clause
maintainer:           Adam Bergmark <adam@bergmark.nl>
author:               Sigbjorn Finne <sof@forkIO.com>
homepage:             https://github.com/bergmark/feed
synopsis:             Interfacing with RSS (v 0.9x, 2.x, 1.0) + Atom feeds.
description:
    Interfacing with RSS (v 0.9x, 2.x, 1.0) + Atom feeds.

    To help working with the multiple feed formats we'\''ve
    ended up with, this set of modules provides parsers,
    pretty printers and some utility code for querying
    and just generally working with a concrete representation
    of feeds in Haskell.

    See here for an example of how to create an Atom feed:
    <https://github.com/bergmark/feed/blob/master/tests/Example/CreateAtom.hs>

    For basic reading and editing of feeds, consult
    the documentation of the Text.Feed.* hierarchy.

category:             Text
abi:                  24e417669e021bb9fce527e218c10aec
exposed:              True
exposed-modules:
    Text.Atom.Feed Text.Atom.Feed.Export Text.Atom.Feed.Import
    Text.Atom.Feed.Link Text.Atom.Feed.Validate Text.Atom.Pub
    Text.Atom.Pub.Export Text.DublinCore.Types Text.Feed.Constructor
    Text.Feed.Export Text.Feed.Import Text.Feed.Query
    Text.Feed.Translate Text.Feed.Types Text.Feed.Util Text.RSS.Export
    Text.RSS.Import Text.RSS.Syntax Text.RSS1.Export Text.RSS1.Import
    Text.RSS1.Syntax Text.RSS1.Utils

hidden-modules:       Data.Text.Util Data.XML.Compat
import-dirs:          /usr/lib/ghc-9.0.1/site-local/feed-1.3.2.0
library-dirs:         /usr/lib/ghc-9.0.1/site-local/feed-1.3.2.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-feed
hs-libraries:         HSfeed-1.3.2.0-AvcCruj4zHFAH4qSaQaXSt
depends:
    base-4.15.0.0 base-compat-0.11.2-EfuzzJ3SbjR74eBdJgKfBC
    bytestring-0.10.12.1 old-locale-1.0.0.7-8b6vATcbl2rGNT5WzdAV1N
    old-time-1.1.0.3-K1bOYVfsfw9D9troqm7gA3
    safe-0.3.19-BCcHjTM7bV690cTfMWPidj text-1.2.4.1 time-1.9.3
    time-locale-compat-0.1.1.5-HOIeHz8A3IdD2UbO8b27LU
    utf8-string-1.0.2-FSV4F6pxd5y7PjtRkbEpDf
    xml-conduit-1.9.1.1-8szrhDccdR56PHnyZ5pHlE
    xml-types-0.3.8-144bFK4Wa4uGyLKj6w2QbB

haddock-interfaces:   /usr/share/doc/haskell-feed/html/feed.haddock
haddock-html:         /usr/share/doc/haskell-feed/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

