#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 graphviz
version:              2999.20.1.0
visibility:           public
id:                   graphviz-2999.20.1.0-8G0Ou8aeKSI29DGrV8qAG5
key:                  graphviz-2999.20.1.0-8G0Ou8aeKSI29DGrV8qAG5
license:              BSD-3-Clause
copyright:            Matthew Sackman, Ivan Lazar Miljenovic
maintainer:           Ivan.Miljenovic@gmail.com
author:               Matthew Sackman, Ivan Lazar Miljenovic
stability:            Beta
homepage:             https://github.com/ivan-m/graphviz
synopsis:             Bindings to Graphviz for graph visualisation.
description:
    This library provides bindings for the Dot language used by the
    Graphviz (<http://graphviz.org/>) suite of programs for visualising
    graphs, as well as functions to call those programs.

    Main features of the graphviz library include:

    * Almost complete coverage of all Graphviz attributes and syntax.

    * Support for specifying clusters.

    * The ability to use a custom node type.

    * Functions for running a Graphviz layout tool with all specified
    output types.

    * The ability to not only generate but also parse Dot code with two
    options: strict and liberal (in terms of ordering of statements).

    * Functions to convert FGL graphs and other graph-like data structures
    to Dot code - including support to group them into clusters - with a
    high degree of customisation by specifying which attributes to use
    and limited support for the inverse operation.

    * Round-trip support for passing an FGL graph through Graphviz to
    augment node and edge labels with positional information, etc.

category:             Graphs, Graphics
abi:                  0903b97e6efb0f9dc97139c2ae06f696
exposed:              True
exposed-modules:
    Data.GraphViz Data.GraphViz.Algorithms Data.GraphViz.Attributes
    Data.GraphViz.Attributes.Colors
    Data.GraphViz.Attributes.Colors.Brewer
    Data.GraphViz.Attributes.Colors.SVG
    Data.GraphViz.Attributes.Colors.X11
    Data.GraphViz.Attributes.Complete Data.GraphViz.Attributes.HTML
    Data.GraphViz.Attributes.Internal Data.GraphViz.Commands
    Data.GraphViz.Commands.IO Data.GraphViz.Exception
    Data.GraphViz.Internal.State Data.GraphViz.Internal.Util
    Data.GraphViz.Parsing Data.GraphViz.PreProcessing
    Data.GraphViz.Printing Data.GraphViz.Types
    Data.GraphViz.Types.Canonical Data.GraphViz.Types.Generalised
    Data.GraphViz.Types.Graph Data.GraphViz.Types.Internal.Common
    Data.GraphViz.Types.Monadic

hidden-modules:
    Data.GraphViz.Algorithms.Clustering Data.GraphViz.Attributes.Arrows
    Data.GraphViz.Attributes.ColorScheme Data.GraphViz.Attributes.Same
    Data.GraphViz.Attributes.Values Data.GraphViz.Commands.Available
    Data.GraphViz.Types.State

import-dirs:          /usr/lib/ghc-9.0.1/site-local/graphviz-2999.20.1.0
library-dirs:         /usr/lib/ghc-9.0.1/site-local/graphviz-2999.20.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/graphviz-2999.20.1.0
hs-libraries:         HSgraphviz-2999.20.1.0-8G0Ou8aeKSI29DGrV8qAG5
depends:
    base-4.15.0.0 bytestring-0.10.12.1
    colour-2.3.6-INQpyJrfu244Q1q0HWiHAI containers-0.6.4.1
    directory-1.3.6.1 dlist-1.0-DqtNBE1aXOzH1lBPsXifRQ
    fgl-5.7.0.3-KVkA9k3t5D032W6Sy3xn17 filepath-1.4.2.1 mtl-2.2.2
    polyparse-1.13-5fuLQzfXOtA1roWYsxD26u process-1.6.11.0
    temporary-1.3-6FIxg0ZrJD07j9FbKd9D73 text-1.2.4.1
    wl-pprint-text-1.2.0.1-DsCJ2fPlaaFCoBzGhODYsl

haddock-interfaces:   /usr/share/doc/haskell-graphviz/html/graphviz.haddock
haddock-html:         /usr/share/doc/haskell-graphviz/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

