#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hackage-security
version:              0.6.0.1
visibility:           public
id:                   hackage-security-0.6.0.1-1T5FoLKCG3N7CEH5mW7oj3
key:                  hackage-security-0.6.0.1-1T5FoLKCG3N7CEH5mW7oj3
license:              BSD-3-Clause
copyright:            Copyright 2015-2016 Well-Typed LLP
maintainer:           cabal-devel@haskell.org
author:               Edsko de Vries
homepage:             https://github.com/haskell/hackage-security
synopsis:             Hackage security library
description:
    The hackage security library provides both server and
    client utilities for securing the Hackage package server
    (<http://hackage.haskell.org/>).  It is based on The Update
    Framework (<http://theupdateframework.com/>), a set of
    recommendations developed by security researchers at
    various universities in the US as well as developers on the
    Tor project (<https://www.torproject.org/>).

    The current implementation supports only index signing,
    thereby enabling untrusted mirrors. It does not yet provide
    facilities for author package signing.

    The library has two main entry points:
    "Hackage.Security.Client" is the main entry point for
    clients (the typical example being @cabal@), and
    "Hackage.Security.Server" is the main entry point for
    servers (the typical example being @hackage-server@).

category:             Distribution
abi:                  f4070af90c10aaea8782e719865b3fbe
exposed:              True
exposed-modules:
    Hackage.Security.Client Hackage.Security.Client.Formats
    Hackage.Security.Client.Repository
    Hackage.Security.Client.Repository.Cache
    Hackage.Security.Client.Repository.HttpLib
    Hackage.Security.Client.Repository.Local
    Hackage.Security.Client.Repository.Remote
    Hackage.Security.Client.Verify Hackage.Security.JSON
    Hackage.Security.Key.Env Hackage.Security.Server
    Hackage.Security.TUF.FileMap Hackage.Security.Trusted
    Hackage.Security.Util.Checked Hackage.Security.Util.Path
    Hackage.Security.Util.Pretty Hackage.Security.Util.Some
    Text.JSON.Canonical

hidden-modules:
    Hackage.Security.Key Hackage.Security.Trusted.TCB
    Hackage.Security.TUF Hackage.Security.TUF.Common
    Hackage.Security.TUF.FileInfo Hackage.Security.TUF.Header
    Hackage.Security.TUF.Layout.Cache Hackage.Security.TUF.Layout.Index
    Hackage.Security.TUF.Layout.Repo Hackage.Security.TUF.Mirrors
    Hackage.Security.TUF.Paths Hackage.Security.TUF.Patterns
    Hackage.Security.TUF.Root Hackage.Security.TUF.Signed
    Hackage.Security.TUF.Snapshot Hackage.Security.TUF.Targets
    Hackage.Security.TUF.Timestamp Hackage.Security.Util.Base64
    Hackage.Security.Util.Exit Hackage.Security.Util.IO
    Hackage.Security.Util.JSON Hackage.Security.Util.Lens
    Hackage.Security.Util.Stack Hackage.Security.Util.TypedEmbedded
    Prelude

import-dirs:          /usr/lib/ghc-9.0.1/site-local/hackage-security-0.6.0.1
library-dirs:         /usr/lib/ghc-9.0.1/site-local/hackage-security-0.6.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/hackage-security-0.6.0.1
hs-libraries:         HShackage-security-0.6.0.1-1T5FoLKCG3N7CEH5mW7oj3
depends:
    Cabal-3.4.0.0 base-4.15.0.0
    base16-bytestring-1.0.1.0-ACUewSgXa2lGPxnToJIotQ
    base64-bytestring-1.2.1.0-1T6dUoRSPJz5Ioae8XlZq2
    bytestring-0.10.12.1 containers-0.6.4.1
    cryptohash-sha256-0.11.102.1-9vt4wQqgpeCLI96cwNF4nv
    directory-1.3.6.1 ed25519-0.0.5.0-AbBojYJLzxR7ElA4311VNK
    filepath-1.4.2.1 ghc-prim-0.7.0 lukko-0.1.1.3-1QdwLd2nOmU1Fu4Hqnvd
    mtl-2.2.2 network-3.1.2.2-HXcjy5szECnDN1PS9jNchP
    network-uri-2.6.4.1-BnEimF9gukhI4cE0Ew2RUr parsec-3.1.14.0
    pretty-1.1.3.6 tar-0.5.1.1-Axr5nzlRtqQ12YxSrGU5NZ
    template-haskell-2.17.0.0 time-1.9.3 transformers-0.5.6.2
    zlib-0.6.2.3-6H3hMes2qwq6KLF45PsaZ5

haddock-interfaces:
    /usr/share/doc/haskell-hackage-security/html/hackage-security.haddock

haddock-html:         /usr/share/doc/haskell-hackage-security/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

