#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 haddock-library
version:              1.10.0
visibility:           public
id:                   haddock-library-1.10.0-6rGY9xFNd4T5spKGwkORJB
key:                  haddock-library-1.10.0-6rGY9xFNd4T5spKGwkORJB
license:              BSD-2-Clause
maintainer:
    Alec Theriault <alec.theriault@gmail.com>, Alex Biehl <alexbiehl@gmail.com>, Simon Hengel <sol@typeful.net>, Mateusz Kowalczyk <fuuzetsu@fuuzetsu.co.uk>

homepage:             http://www.haskell.org/haddock/
synopsis:             Library exposing some functionality of Haddock.
description:
    Haddock is a documentation-generation tool for Haskell
    libraries. These modules expose some
    functionality of it without pulling in the GHC
    dependency. Please note that the API is likely
    to change so be sure to specify upper bounds in
    your projects. For interacting with Haddock
    itself, see the [haddock package](https://hackage.haskell.org/package/haddock).

category:             Documentation
abi:                  ecb1fd2a09b1699818e200997c7b02f7
exposed:              True
exposed-modules:
    Documentation.Haddock.Doc Documentation.Haddock.Markup
    Documentation.Haddock.Parser Documentation.Haddock.Types

hidden-modules:
    CompatPrelude Documentation.Haddock.Parser.Util
    Documentation.Haddock.Parser.Monad
    Documentation.Haddock.Parser.Identifier

import-dirs:          /usr/lib/ghc-9.0.1/site-local/haddock-library-1.10.0
library-dirs:         /usr/lib/ghc-9.0.1/site-local/haddock-library-1.10.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/haddock-library-1.10.0
hs-libraries:         HShaddock-library-1.10.0-6rGY9xFNd4T5spKGwkORJB
depends:
    base-4.15.0.0 bytestring-0.10.12.1 containers-0.6.4.1
    parsec-3.1.14.0 text-1.2.4.1 transformers-0.5.6.2

haddock-interfaces:
    /usr/share/doc/haskell-haddock-library/html/haddock-library.haddock

haddock-html:         /usr/share/doc/haskell-haddock-library/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

