#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hasql
version:              1.4.5.3
visibility:           public
id:                   hasql-1.4.5.3-4MmuSX2e7jbCKn13ZaFlCM
key:                  hasql-1.4.5.3-4MmuSX2e7jbCKn13ZaFlCM
license:              MIT
copyright:            (c) 2014, Nikita Volkov
maintainer:           Nikita Volkov <nikita.y.volkov@mail.ru>
author:               Nikita Volkov <nikita.y.volkov@mail.ru>
homepage:             https://github.com/nikita-volkov/hasql
synopsis:             An efficient PostgreSQL driver with a flexible mapping API
description:
    Root of the \"hasql\" ecosystem.
    For details and tutorials see
    <https://github.com/nikita-volkov/hasql the readme>.

    The API comes free from all kinds of exceptions. All error-reporting is explicit and is presented using the '\''Either'\'' type.

category:             Hasql, Database, PostgreSQL
abi:                  f4be9f9f53cb8ab42dc2489931dd46f9
exposed:              True
exposed-modules:
    Hasql.Connection Hasql.Decoders Hasql.Encoders Hasql.Session
    Hasql.Statement

hidden-modules:
    Hasql.Private.Prelude Hasql.Private.Errors Hasql.Private.PTI
    Hasql.Private.IO Hasql.Private.Session Hasql.Private.Connection
    Hasql.Private.PreparedStatementRegistry Hasql.Private.Settings
    Hasql.Private.Commands Hasql.Private.Decoders
    Hasql.Private.Decoders.Array Hasql.Private.Decoders.Composite
    Hasql.Private.Decoders.Value Hasql.Private.Decoders.Row
    Hasql.Private.Decoders.Result Hasql.Private.Decoders.Results
    Hasql.Private.Encoders Hasql.Private.Encoders.Array
    Hasql.Private.Encoders.Value Hasql.Private.Encoders.Params

import-dirs:          /usr/lib/ghc-9.0.1/site-local/hasql-1.4.5.3
library-dirs:         /usr/lib/ghc-9.0.1/site-local/hasql-1.4.5.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/hasql-1.4.5.3
hs-libraries:         HShasql-1.4.5.3-4MmuSX2e7jbCKn13ZaFlCM
depends:
    attoparsec-0.14.1-B8P567zH1pOF107V9enGUK base-4.15.0.0
    bytestring-0.10.12.1
    bytestring-strict-builder-0.4.5.4-JwI8I262yt35iBh1vwQpxa
    contravariant-1.5.5-1Tz7FaRP9yoKqkcBKkQ76A
    dlist-1.0-DqtNBE1aXOzH1lBPsXifRQ
    hashable-1.3.4.0-IEtvls2JnYMCj5AtMjw8bF
    hashtables-1.2.4.2-9qPOqeOWa63CnwbSi2xG6U mtl-2.2.2
    postgresql-binary-0.12.4.1-3qYpzyHKaPm14bhaelhnwZ
    postgresql-libpq-0.9.4.3-4UpE2VczKgl8p7NC0fd3Q8
    profunctors-5.6.2-JSpjDLFOHziFMPQ6l5NowS text-1.2.4.1
    text-builder-0.6.6.3-89tvPfcS68dCbjNXjhLT5x transformers-0.5.6.2
    vector-0.12.3.1-HMAplmdcuCN6dtD8e6QGwL

haddock-interfaces:   /usr/share/doc/haskell-hasql/html/hasql.haddock
haddock-html:         /usr/share/doc/haskell-hasql/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

