#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hedgehog
version:              1.0.5
visibility:           public
id:                   hedgehog-1.0.5-8z7NBgfTglF1e9xp1fRYBr
key:                  hedgehog-1.0.5-8z7NBgfTglF1e9xp1fRYBr
license:              BSD-3-Clause
maintainer:           Jacob Stanley <jacob@stanley.io>
author:               Jacob Stanley
homepage:             https://hedgehog.qa
synopsis:             Release with confidence.
description:
    <http://hedgehog.qa/ Hedgehog> automatically generates a comprehensive array
    of test cases, exercising your software in ways human testers would never
    imagine.

    Generate hundreds of test cases automatically, exposing even the
    most insidious of corner cases. Failures are automatically simplified, giving
    developers coherent, intelligible error messages.

    To get started quickly, see the <https://github.com/hedgehogqa/haskell-hedgehog/tree/master/hedgehog-example examples>.

category:             Testing
abi:                  310e28754b66914bb8c2b852a94b19b1
exposed:              True
exposed-modules:
    Hedgehog Hedgehog.Gen Hedgehog.Internal.Config
    Hedgehog.Internal.Discovery Hedgehog.Internal.Distributive
    Hedgehog.Internal.Exception Hedgehog.Internal.Gen
    Hedgehog.Internal.HTraversable Hedgehog.Internal.Opaque
    Hedgehog.Internal.Prelude Hedgehog.Internal.Property
    Hedgehog.Internal.Queue Hedgehog.Internal.Range
    Hedgehog.Internal.Region Hedgehog.Internal.Report
    Hedgehog.Internal.Runner Hedgehog.Internal.Seed
    Hedgehog.Internal.Show Hedgehog.Internal.Shrink
    Hedgehog.Internal.Source Hedgehog.Internal.State
    Hedgehog.Internal.TH Hedgehog.Internal.Tree
    Hedgehog.Internal.Tripping Hedgehog.Main Hedgehog.Range

import-dirs:          /usr/lib/ghc-9.0.1/site-local/hedgehog-1.0.5
library-dirs:         /usr/lib/ghc-9.0.1/site-local/hedgehog-1.0.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/hedgehog-1.0.5
hs-libraries:         HShedgehog-1.0.5-8z7NBgfTglF1e9xp1fRYBr
depends:
    ansi-terminal-0.11-DOUngjGM5e9DBdxKKdJoVq
    async-2.2.3-9hcO3XZAP863cAPa5inA8N base-4.15.0.0
    bytestring-0.10.12.1
    concurrent-output-1.10.12-9Gz5NVwjFD4BtrunVcdLSw containers-0.6.4.1
    deepseq-1.4.5.0 directory-1.3.6.1
    erf-2.0.0.0-3zMgPptNqkU60SoZmaKCwc exceptions-0.10.4
    lifted-async-0.10.2.1-Asb38MEK19gEDVjtmHIBjY
    mmorph-1.2.0-Ajh0k0abpSlDb3Q6HDcBvb
    monad-control-1.0.3.1-buqreaszgTDhqS64rvHY6 mtl-2.2.2
    pretty-show-1.10-G4SfLXvOfw8HasEUHDrqxD
    primitive-0.7.2.0-H9HP2FbaY5C1JlRHDKja9P
    random-1.2.1-Iy7yOfCz74T6VyvkhFUFfX
    resourcet-1.2.4.3-8689t6OWpHGD0T1pI8fpT0 stm-2.5.0.0
    template-haskell-2.17.0.0 text-1.2.4.1 time-1.9.3
    transformers-0.5.6.2 transformers-base-0.4.6-BxowhPHAvTf3506d7p3ISW
    wl-pprint-annotated-0.1.0.1-5rDpAqJVDxt9zmtQE9xFrp

haddock-interfaces:   /usr/share/doc/haskell-hedgehog/html/hedgehog.haddock
haddock-html:         /usr/share/doc/haskell-hedgehog/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

