#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hledger-lib
version:              1.22.2
visibility:           public
id:                   hledger-lib-1.22.2-581CnOwEIiGDTYq3PpozFg
key:                  hledger-lib-1.22.2-581CnOwEIiGDTYq3PpozFg
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:
    A reusable library providing the core functionality of hledger

description:
    A reusable library containing hledger'\''s core functionality.
    This is used by most hledger* packages so that they support the same
    common file formats, command line options, reports etc.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  45ef2d5827db7938f3b59c9e682dfde8
exposed:              True
exposed-modules:
    Hledger Hledger.Data Hledger.Data.Account Hledger.Data.AccountName
    Hledger.Data.Amount Hledger.Data.Commodity Hledger.Data.Dates
    Hledger.Data.Journal Hledger.Data.Json Hledger.Data.Ledger
    Hledger.Data.Period Hledger.Data.PeriodicTransaction
    Hledger.Data.Posting Hledger.Data.RawOptions
    Hledger.Data.StringFormat Hledger.Data.Timeclock
    Hledger.Data.Transaction Hledger.Data.TransactionModifier
    Hledger.Data.Types Hledger.Data.Valuation Hledger.Query
    Hledger.Read Hledger.Read.Common Hledger.Read.CsvReader
    Hledger.Read.JournalReader Hledger.Read.TimeclockReader
    Hledger.Read.TimedotReader Hledger.Reports
    Hledger.Reports.AccountTransactionsReport
    Hledger.Reports.BalanceReport Hledger.Reports.BudgetReport
    Hledger.Reports.EntriesReport Hledger.Reports.MultiBalanceReport
    Hledger.Reports.PostingsReport Hledger.Reports.ReportOptions
    Hledger.Reports.ReportTypes Hledger.Reports.TransactionsReport
    Hledger.Utils Hledger.Utils.Color Hledger.Utils.Debug
    Hledger.Utils.Parse Hledger.Utils.Regex Hledger.Utils.String
    Hledger.Utils.Test Hledger.Utils.Text Hledger.Utils.Tree
    Hledger.Utils.UTF8IOCompat Text.Tabular.AsciiWide

hidden-modules:
    Text.Megaparsec.Custom Text.WideString Paths_hledger_lib

import-dirs:          /usr/lib/ghc-9.0.1/site-local/hledger-lib-1.22.2
library-dirs:         /usr/lib/ghc-9.0.1/site-local/hledger-lib-1.22.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/hledger-lib-1.22.2
hs-libraries:         HShledger-lib-1.22.2-581CnOwEIiGDTYq3PpozFg
depends:
    Decimal-0.5.2-2HoOOxzDA6751UAvDjOkzb
    Glob-0.10.2-IjufxCfuL2iDDJXTBrJ8rg
    aeson-1.5.6.0-FZsVpvEwT8z4bK1D26EwAs
    aeson-pretty-0.8.9-4VpDxWXnDJA8Bu2hhX3Ado
    ansi-terminal-0.11-DOUngjGM5e9DBdxKKdJoVq array-0.5.4.0
    base-4.15.0.0 base-compat-batteries-0.11.2-Cs6UiKAcT2NJzvnx9vzluN
    blaze-markup-0.8.2.8-8PH9vh1UAZb2ZrMELNvjH9 bytestring-0.10.12.1
    call-stack-0.4.0-8Okwb0cowpe8mB1pBLnCB
    cassava-0.5.2.0-DYG4UM4YMmzDjEg4aMoOd3
    cassava-megaparsec-2.0.3-FOJEgy57QoU3qHKhtWtyIf
    cmdargs-0.10.21-9JSptK8vQ5KGyQ5LWB6hlS containers-0.6.4.1
    data-default-0.7.1.1-5RJjHNv19ESJeD93LU2jRn directory-1.3.6.1
    extra-1.7.10-Ic4saaul5v2Abuas5lK2xt
    file-embed-0.0.14.0-DpVDNlFaM0M9fTuZiTfuRf filepath-1.4.2.1
    hashtables-1.2.4.2-9qPOqeOWa63CnwbSi2xG6U
    megaparsec-9.2.0-LDByiSVjBO1EnZacitxvZW mtl-2.2.2
    old-time-1.1.0.3-K1bOYVfsfw9D9troqm7gA3
    parser-combinators-1.3.0-5jHqYWwdpCqFWQLuYLRvi6
    pretty-simple-4.0.0.0-BcM5KtwtktD4NrvOl2ufyr
    regex-tdfa-1.3.1.1-JysT5HHQf7SDqagoTfdJw
    safe-0.3.19-BCcHjTM7bV690cTfMWPidj
    tabular-0.2.2.8-8JF65zbpqg3J2xw1bK6aDa
    tasty-1.4.2-Bm6RHH7ID0qJ5MVdVnudQG
    tasty-hunit-0.10.0.3-1dRo8ogaXCS2SAOASjKXvF
    template-haskell-2.17.0.0 text-1.2.4.1 time-1.9.3
    timeit-2.0-IUvGmumxlJTJLVT8F6LloM transformers-0.5.6.2
    uglymemo-0.1.0.1-K1PShlSzv8xEub4UZShWvw
    unordered-containers-0.2.14.0-7Twq3Q78XsnAV2eREMKYwX
    utf8-string-1.0.2-FSV4F6pxd5y7PjtRkbEpDf

haddock-interfaces:   /usr/share/doc/haskell-hledger-lib/html/hledger-lib.haddock
haddock-html:         /usr/share/doc/haskell-hledger-lib/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

