#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hOpenPGP
version:              2.9.5
visibility:           public
id:                   hOpenPGP-2.9.5-1XmtSYyanOw6m3fLqm7G39
key:                  hOpenPGP-2.9.5-1XmtSYyanOw6m3fLqm7G39
license:              MIT
copyright:            2012-2020  Clint Adams
maintainer:           Clint Adams <clint@debian.org>
author:               Clint Adams
homepage:             https://salsa.debian.org/clint/hOpenPGP
synopsis:             native Haskell implementation of OpenPGP (RFC4880)
description:
    native Haskell implementation of OpenPGP (RFC4880), plus Camellia (RFC5581), plus ECC (RFC6637)

category:             Codec, Data
abi:                  245749443ce4c8469330458ec1dc733e
exposed:              True
exposed-modules:
    Codec.Encryption.OpenPGP.CFB Codec.Encryption.OpenPGP.Compression
    Codec.Encryption.OpenPGP.Expirations
    Codec.Encryption.OpenPGP.Fingerprint
    Codec.Encryption.OpenPGP.KeyInfo
    Codec.Encryption.OpenPGP.KeySelection
    Codec.Encryption.OpenPGP.KeyringParser
    Codec.Encryption.OpenPGP.Ontology Codec.Encryption.OpenPGP.S2K
    Codec.Encryption.OpenPGP.SecretKey
    Codec.Encryption.OpenPGP.Serialize
    Codec.Encryption.OpenPGP.SignatureQualities
    Codec.Encryption.OpenPGP.Signatures Codec.Encryption.OpenPGP.Types
    Data.Conduit.OpenPGP.Compression Data.Conduit.OpenPGP.Decrypt
    Data.Conduit.OpenPGP.Filter Data.Conduit.OpenPGP.Keyring
    Data.Conduit.OpenPGP.Keyring.Instances Data.Conduit.OpenPGP.Verify

hidden-modules:
    Codec.Encryption.OpenPGP.Internal
    Codec.Encryption.OpenPGP.Internal.CryptoCipherTypes
    Codec.Encryption.OpenPGP.Internal.Cryptonite
    Codec.Encryption.OpenPGP.Internal.HOBlockCipher
    Codec.Encryption.OpenPGP.SerializeForSigs
    Codec.Encryption.OpenPGP.Types.Internal.Base
    Codec.Encryption.OpenPGP.Types.Internal.CryptoniteNewtypes
    Codec.Encryption.OpenPGP.Types.Internal.PacketClass
    Codec.Encryption.OpenPGP.Types.Internal.PKITypes
    Codec.Encryption.OpenPGP.Types.Internal.Pkt
    Codec.Encryption.OpenPGP.Types.Internal.PrettyUtils
    Codec.Encryption.OpenPGP.Types.Internal.TK
    Codec.Encryption.OpenPGP.BlockCipher

import-dirs:          /usr/lib/ghc-9.0.1/site-local/hOpenPGP-2.9.5
library-dirs:         /usr/lib/ghc-9.0.1/site-local/hOpenPGP-2.9.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/hOpenPGP-2.9.5
hs-libraries:         HShOpenPGP-2.9.5-1XmtSYyanOw6m3fLqm7G39
depends:
    aeson-1.5.6.0-FZsVpvEwT8z4bK1D26EwAs
    asn1-encoding-0.9.6-GST7u8YWSVMBlxeVag7x5g
    attoparsec-0.14.1-B8P567zH1pOF107V9enGUK base-4.15.0.0
    base16-bytestring-1.0.1.0-ACUewSgXa2lGPxnToJIotQ
    bifunctors-5.5.11-6LpscOqvpXFF7to3ER7bDY binary-0.8.8.0
    binary-conduit-1.3.1-ElBXbEM7C9zKRQwCkx2la9 bytestring-0.10.12.1
    bz2-1.0.1.0-BpivtCPxIr3BxeTAcK2IcP
    conduit-1.3.4.2-G1HkDA3DXNW8qvzQqLFdeJ
    conduit-extra-1.3.5-2QgTdU2xsXFLiiHtDLIybY containers-0.6.4.1
    crypto-cipher-types-0.0.9-2oAnHtqeRctAMvgq4mBtVl
    cryptonite-0.29-GRn4QfSajtp4ejYMImOiTS
    errors-2.3.0-FhBmHY7sMIf8wTT2E4ozOx
    hashable-1.3.4.0-IEtvls2JnYMCj5AtMjw8bF
    incremental-parser-0.5.0.2-7u2uUxAukSkGDXnY5eZWmL
    ixset-typed-0.5-2HtNNAIxSMWykAaHALClV
    lens-5.0.1-E7Tul8EWHuqGCOW8gNOuPe
    memory-0.16.0-CGaPOmXCTce28vOCDDnDFr
    monad-loops-0.4.3-CoSqVlGqFyAAyK5Lg2m9AJ
    nettle-0.3.0-LBTadu1XgKbBXssreAKwoe
    network-uri-2.6.4.1-BnEimF9gukhI4cE0Ew2RUr
    openpgp-asciiarmor-0.1.2-6ohLBxNpDVlDZwhJpQCSLe
    prettyprinter-1.7.1-Cr9OhaeuhZG9wS7WBggFWd
    resourcet-1.2.4.3-8689t6OWpHGD0T1pI8fpT0
    split-0.2.3.4-BM0SHXGG6RG9udnJVWQWWX text-1.2.4.1 time-1.9.3
    time-locale-compat-0.1.1.5-HOIeHz8A3IdD2UbO8b27LU
    transformers-0.5.6.2 unliftio-core-0.2.0.1-2baD1vXgUkB5a1NRn2rSLN
    unordered-containers-0.2.14.0-7Twq3Q78XsnAV2eREMKYwX
    zlib-0.6.2.3-6H3hMes2qwq6KLF45PsaZ5

haddock-interfaces:   /usr/share/doc/haskell-hopenpgp/html/hOpenPGP.haddock
haddock-html:         /usr/share/doc/haskell-hopenpgp/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

