#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 HsYAML-aeson
version:              0.2.0.1
visibility:           public
id:                   HsYAML-aeson-0.2.0.1-Jo6QU3LDF3eAPJJxfGbvNp
key:                  HsYAML-aeson-0.2.0.1-Jo6QU3LDF3eAPJJxfGbvNp
license:              GPL-2.0-or-later
copyright:            2018-2019 Herbert Valerio Riedel
maintainer:           hvr@gnu.org, Andreas Abel
author:               Herbert Valerio Riedel
synopsis:             JSON to YAML Adapter
description:
    The [YAML 1.2](https://yaml.org/spec/1.2/spec.html) format provides
    a much richer data-model and feature-set
    than the [JavaScript Object Notation (JSON)](https://tools.ietf.org/html/rfc7159) format.
    However, sometimes it'\''s desirable to ignore the extra capabilities
    and treat YAML as if it was merely a more convenient markup format
    for humans to write JSON data. To this end this module provides a
    compatibility layer atop [HsYAML](https://hackage.haskell.org/package/HsYAML)
    which allows decoding YAML documents in the more limited JSON data-model while also providing
    convenience by reusing [aeson](https://hackage.haskell.org/package/aeson)'\''s
    '\''FromJSON'\'' instances for decoding the YAML data into native Haskell data types.

category:             Text, Codec, Web, JSON, YAML
abi:                  8652a1c1e7145d308c87f742efe4edfc
exposed:              True
exposed-modules:      Data.YAML.Aeson
import-dirs:          /usr/lib/ghc-9.0.1/site-local/HsYAML-aeson-0.2.0.1
library-dirs:         /usr/lib/ghc-9.0.1/site-local/HsYAML-aeson-0.2.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/HsYAML-aeson-0.2.0.1
hs-libraries:         HSHsYAML-aeson-0.2.0.1-Jo6QU3LDF3eAPJJxfGbvNp
depends:
    HsYAML-0.2.1.0-LAsgCVHgNRz6f9JP8l2UCC
    aeson-1.5.6.0-FZsVpvEwT8z4bK1D26EwAs base-4.15.0.0
    bytestring-0.10.12.1 containers-0.6.4.1 mtl-2.2.2
    scientific-0.3.7.0-80Xt5iXHAGIBd7njyVx1yZ text-1.2.4.1
    unordered-containers-0.2.14.0-7Twq3Q78XsnAV2eREMKYwX
    vector-0.12.3.1-HMAplmdcuCN6dtD8e6QGwL

haddock-interfaces:
    /usr/share/doc/haskell-hsyaml-aeson/html/HsYAML-aeson.haddock

haddock-html:         /usr/share/doc/haskell-hsyaml-aeson/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

