#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 indexed-traversable-instances
version:              0.1
visibility:           public
id:                   indexed-traversable-instances-0.1-3pzgVew5jHK82fWMzre0Cg
key:                  indexed-traversable-instances-0.1-3pzgVew5jHK82fWMzre0Cg
license:              BSD-2-Clause
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:               Edward Kmett
synopsis:
    More instances of FunctorWithIndex, FoldableWithIndex, TraversableWithIndex

description:
    This package provides extra instances for type-classes in the [indexed-traversable](https://hackage.haskell.org/package/indexed-traversable) package.

    The intention is to keep this package minimal;
    it provides instances that formely existed in @lens@ or @optics-extra@.
    We recommend putting other instances directly into their defining packages.
    The @indexed-traversable@ package is light, having only GHC boot libraries
    as its dependencies.

category:             Data
abi:                  db8e5f3b017aba5f43a8afdccbe7c9ff
exposed:              True
exposed-modules:      Data.Functor.WithIndex.Instances
import-dirs:
    /usr/lib/ghc-9.0.1/site-local/indexed-traversable-instances-0.1

library-dirs:
    /usr/lib/ghc-9.0.1/site-local/indexed-traversable-instances-0.1

dynamic-library-dirs: /usr/lib
data-dir:
    /usr/share/x86_64-linux-ghc-9.0.1/indexed-traversable-instances-0.1

hs-libraries:         HSindexed-traversable-instances-0.1-3pzgVew5jHK82fWMzre0Cg
depends:
    base-4.15.0.0 indexed-traversable-0.1.1-K0YsJRCif6Q7nMYcYE7GvA
    tagged-0.8.6.1-FL843C40q4d1DeuwYADr25
    unordered-containers-0.2.14.0-7Twq3Q78XsnAV2eREMKYwX
    vector-0.12.3.1-HMAplmdcuCN6dtD8e6QGwL

haddock-interfaces:
    /usr/share/doc/haskell-indexed-traversable-instances/html/indexed-traversable-instances.haddock

haddock-html:         /usr/share/doc/haskell-indexed-traversable-instances/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

