#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 lattices
version:              2.0.2
visibility:           public
id:                   lattices-2.0.2-5ZLOKyYp1DcHexiPDfHQ7Q
key:                  lattices-2.0.2-5ZLOKyYp1DcHexiPDfHQ7Q
license:              BSD-3-Clause
copyright:
    (C) 2010-2015 Maximilian Bolingbroke, 2016-2019 Oleg Grenrus

maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:
    Maximilian Bolingbroke <batterseapower@hotmail.com>, Oleg Grenrus <oleg.grenrus@iki.fi>

homepage:             http://github.com/phadej/lattices/
synopsis:
    Fine-grained library for constructing and manipulating lattices

description:
    In mathematics, a lattice is a partially ordered set in which every two
    elements @x@ and @y@ have a unique supremum (also called a least upper bound, join, or @x /\\ y@)
    and a unique infimum (also called a greatest lower bound, meet, or @x \\/ y@).

    This package provide type-classes for different lattice types, as well
    as a class for the partial order.

category:             Math
abi:                  b93afeb79e6aa2cd3088d2766aac2423
exposed:              True
exposed-modules:
    Algebra.Heyting Algebra.Heyting.Free Algebra.Heyting.Free.Expr
    Algebra.Lattice Algebra.Lattice.Divisibility
    Algebra.Lattice.Dropped Algebra.Lattice.Free
    Algebra.Lattice.Free.Final Algebra.Lattice.Levitated
    Algebra.Lattice.Lexicographic Algebra.Lattice.Lifted
    Algebra.Lattice.M2 Algebra.Lattice.M3 Algebra.Lattice.N5
    Algebra.Lattice.Op Algebra.Lattice.Ordered Algebra.Lattice.Stacked
    Algebra.Lattice.Unicode Algebra.Lattice.Wide
    Algebra.Lattice.ZeroHalfOne Algebra.PartialOrd
    Algebra.PartialOrd.Instances

import-dirs:          /usr/lib/ghc-9.0.1/site-local/lattices-2.0.2
library-dirs:         /usr/lib/ghc-9.0.1/site-local/lattices-2.0.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/lattices-2.0.2
hs-libraries:         HSlattices-2.0.2-5ZLOKyYp1DcHexiPDfHQ7Q
depends:
    QuickCheck-2.14.2-3f9Gw3UEGqTK3AyHIcW3dz base-4.15.0.0
    base-compat-0.11.2-EfuzzJ3SbjR74eBdJgKfBC containers-0.6.4.1
    deepseq-1.4.5.0 hashable-1.3.4.0-IEtvls2JnYMCj5AtMjw8bF
    integer-logarithms-1.0.3.1-2aDPDo9uecRBlUQZ3qjecW
    semigroupoids-5.3.6-JFZbW6XT2Qu838ghLJLro6
    tagged-0.8.6.1-FL843C40q4d1DeuwYADr25 transformers-0.5.6.2
    universe-base-1.1.3-1QHK8BYseToEn3ARR9NKTN
    universe-reverse-instances-1.1.1-qqb1hNv5q9A1TgYnGX8XA
    unordered-containers-0.2.14.0-7Twq3Q78XsnAV2eREMKYwX

haddock-interfaces:   /usr/share/doc/haskell-lattices/html/lattices.haddock
haddock-html:         /usr/share/doc/haskell-lattices/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

