#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 libmpd
version:              0.10.0.0
visibility:           public
id:                   libmpd-0.10.0.0-2J1vcCZ1SjfLcTAnpQ1ivE
key:                  libmpd-0.10.0.0-2J1vcCZ1SjfLcTAnpQ1ivE
license:              MIT
copyright:
    Ben Sinclair 2005-2009, Joachim Fasting 2007-2015,
    Daniel Schoepe 2009, Andrzej Rybczak 2010,
    Simon Hengel 2011-2014, Niklas Haas 2012,
    Matvey Aksenov 2014, Wieland Hoffmann 2014,
    Tim Heap 2014, Tobias Brandt 2014

maintainer:           Joachim Fasting <joachifm@fastmail.fm>
author:               Ben Sinclair
stability:            beta
homepage:             http://github.com/vimus/libmpd-haskell#readme
synopsis:             An MPD client library.
description:          A client library for MPD, the Music Player Daemon.
category:             Network, Sound
abi:                  c1c27b6b9395f7f8115dd0c7720ef9cf
exposed:              True
exposed-modules:
    Network.MPD Network.MPD.Applicative
    Network.MPD.Applicative.ClientToClient
    Network.MPD.Applicative.Connection
    Network.MPD.Applicative.CurrentPlaylist
    Network.MPD.Applicative.Database Network.MPD.Applicative.Mount
    Network.MPD.Applicative.Output
    Network.MPD.Applicative.PlaybackControl
    Network.MPD.Applicative.PlaybackOptions
    Network.MPD.Applicative.Reflection Network.MPD.Applicative.Status
    Network.MPD.Applicative.Stickers
    Network.MPD.Applicative.StoredPlaylists
    Network.MPD.Commands.Extensions Network.MPD.Core

hidden-modules:
    Network.MPD.Core.Class Network.MPD.Core.Error Network.MPD.Commands
    Network.MPD.Commands.Arg Network.MPD.Commands.Parse
    Network.MPD.Commands.Query Network.MPD.Commands.Types
    Network.MPD.Commands.ClientToClient Network.MPD.Commands.Status
    Network.MPD.Commands.PlaybackOptions
    Network.MPD.Commands.PlaybackControl
    Network.MPD.Commands.CurrentPlaylist
    Network.MPD.Commands.StoredPlaylists Network.MPD.Commands.Database
    Network.MPD.Commands.Stickers Network.MPD.Commands.Connection
    Network.MPD.Commands.Output Network.MPD.Commands.Reflection
    Network.MPD.Commands.Mount Network.MPD.Applicative.Util
    Network.MPD.Applicative.Internal Network.MPD.Util

import-dirs:          /usr/lib/ghc-9.0.1/site-local/libmpd-0.10.0.0
library-dirs:         /usr/lib/ghc-9.0.1/site-local/libmpd-0.10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/libmpd-0.10.0.0
hs-libraries:         HSlibmpd-0.10.0.0-2J1vcCZ1SjfLcTAnpQ1ivE
depends:
    attoparsec-0.14.1-B8P567zH1pOF107V9enGUK base-4.15.0.0
    bytestring-0.10.12.1 containers-0.6.4.1
    data-default-class-0.1.2.0-LBmwYNzg9cwLSaLiX5AQfC filepath-1.4.2.1
    mtl-2.2.2 network-3.1.2.2-HXcjy5szECnDN1PS9jNchP
    safe-exceptions-0.1.7.2-JOI5UtUHqC0IdzhxC8gvK0 text-1.2.4.1
    time-1.9.3 utf8-string-1.0.2-FSV4F6pxd5y7PjtRkbEpDf

haddock-interfaces:   /usr/share/doc/haskell-libmpd/html/libmpd.haddock
haddock-html:         /usr/share/doc/haskell-libmpd/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

