#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 lsp
version:              1.2.0.1
visibility:           public
id:                   lsp-1.2.0.1-euopm48q1qKcSxWYetfEL
key:                  lsp-1.2.0.1-euopm48q1qKcSxWYetfEL
license:              MIT
copyright:            Alan Zimmerman, 2016-2021
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/haskell/lsp
synopsis:             Haskell library for the Microsoft Language Server Protocol
description:
    An implementation of the types, and basic message server to
    allow language implementors to support the Language Server
    Protocol for their specific language.

    An example of this is for Haskell via the Haskell Language
    Server, at https://github.com/haskell/haskell-language-server

category:             Development
abi:                  12416e833a92a46a46e41ef9c73faafb
exposed:              True
exposed-modules:
    Language.LSP.Diagnostics, Language.LSP.Server,
    Language.LSP.Types from lsp-types-1.3.0.1-DuD6IXWiubRAfMVYQBVxtF:Language.LSP.Types,
    Language.LSP.Types.Capabilities from lsp-types-1.3.0.1-DuD6IXWiubRAfMVYQBVxtF:Language.LSP.Types.Capabilities,
    Language.LSP.Types.Lens from lsp-types-1.3.0.1-DuD6IXWiubRAfMVYQBVxtF:Language.LSP.Types.Lens,
    Language.LSP.VFS from lsp-types-1.3.0.1-DuD6IXWiubRAfMVYQBVxtF:Language.LSP.VFS

hidden-modules:
    Language.LSP.Server.Core Language.LSP.Server.Control
    Language.LSP.Server.Processing

import-dirs:          /usr/lib/ghc-9.0.1/site-local/lsp-1.2.0.1
library-dirs:         /usr/lib/ghc-9.0.1/site-local/lsp-1.2.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/lsp-1.2.0.1
hs-libraries:         HSlsp-1.2.0.1-euopm48q1qKcSxWYetfEL
depends:
    aeson-1.5.6.0-FZsVpvEwT8z4bK1D26EwAs
    async-2.2.3-9hcO3XZAP863cAPa5inA8N
    attoparsec-0.14.1-B8P567zH1pOF107V9enGUK base-4.15.0.0
    bytestring-0.10.12.1 containers-0.6.4.1
    data-default-0.7.1.1-5RJjHNv19ESJeD93LU2jRn
    dependent-map-0.4.0.0-KYAtBTM1O4tCuiRphQzM2D exceptions-0.10.4
    hashable-1.3.4.0-IEtvls2JnYMCj5AtMjw8bF
    hslogger-1.3.1.0-2AG1ImTRkk7Cy6tgOIQFJE
    lens-5.0.1-E7Tul8EWHuqGCOW8gNOuPe
    lsp-types-1.3.0.1-DuD6IXWiubRAfMVYQBVxtF mtl-2.2.2
    network-uri-2.6.4.1-BnEimF9gukhI4cE0Ew2RUr
    random-1.2.1-Iy7yOfCz74T6VyvkhFUFfX
    scientific-0.3.7.0-80Xt5iXHAGIBd7njyVx1yZ
    sorted-list-0.2.1.0-GAuY2s8imm748N24vRN1OU stm-2.5.0.0 text-1.2.4.1
    time-1.9.3 transformers-0.5.6.2
    unliftio-core-0.2.0.1-2baD1vXgUkB5a1NRn2rSLN
    unordered-containers-0.2.14.0-7Twq3Q78XsnAV2eREMKYwX
    uuid-1.3.15-CqqeGHsi76c5zqF2MOLAcg

haddock-interfaces:   /usr/share/doc/haskell-lsp/html/lsp.haddock
haddock-html:         /usr/share/doc/haskell-lsp/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

