#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 lumberjack
version:              1.0.0.1
visibility:           public
id:                   lumberjack-1.0.0.1-LDkUNv08rqKTvkhRvDobT
key:                  lumberjack-1.0.0.1-LDkUNv08rqKTvkhRvDobT
license:              ISC
copyright:            2020, Galois Inc.
maintainer:           kquick@galois.com
author:               Kevin Quick
homepage:             https://github.com/GaloisInc/lumberjack
synopsis:             Trek through your code forest and make logs
description:
    This is a logging facility.  Yes, there are many, and this is the one
    with a beard, wearing flannel and boots, that gets the job done.  It'\''s
    not the fanciest, it doesn'\''t have a cargo-van full of features.  This
    logger is designed to be straightforward to use, provide a good set of
    standard features, and be useable across a broad set of code.

    * Logging itself is a monadic activity.  This activity is most often
    performed in a monad stack with a MonadIO context to allow
    writing to files.

    * The specific logging action implementations are managed separately
    from the actions of logging messages in the target code.  This
    allows logging to be configurable and the manner of logging to
    be specified at startup time without requiring changes in the
    code from which log messages are being generated.

    * The logging implementation code can use contravariant functors to
    adjust existing logging.

    * Main code will typically retrieve the logging actions from a Reader
    context in your monad stack.  That said, Log actions are not tied
    to an enclosing Monad.  There are helpers to support a Monad which
    can store Log actions, but Log actions can also be explicitly
    passed and used.

    * The prettyprinter package is used for formatting.

category:             Logging
abi:                  ceacb83fb2457a56a4338e86f8c66545
exposed:              True
exposed-modules:      Lumberjack
import-dirs:          /usr/lib/ghc-9.0.1/site-local/lumberjack-1.0.0.1
library-dirs:         /usr/lib/ghc-9.0.1/site-local/lumberjack-1.0.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/lumberjack-1.0.0.1
hs-libraries:         HSlumberjack-1.0.0.1-LDkUNv08rqKTvkhRvDobT
depends:
    base-4.15.0.0 contravariant-1.5.5-1Tz7FaRP9yoKqkcBKkQ76A
    exceptions-0.10.4 mtl-2.2.2
    prettyprinter-1.7.1-Cr9OhaeuhZG9wS7WBggFWd
    prettyprinter-ansi-terminal-1.1.3-56brpgZIyjX2iwvXfjkCBe
    text-1.2.4.1 time-1.9.3

haddock-interfaces:   /usr/share/doc/haskell-lumberjack/html/lumberjack.haddock
haddock-html:         /usr/share/doc/haskell-lumberjack/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

