#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 math-functions
version:              0.3.4.2
visibility:           public
id:                   math-functions-0.3.4.2-6tmWZ95gLEW2kGWXNJWTwg
key:                  math-functions-0.3.4.2-6tmWZ95gLEW2kGWXNJWTwg
license:              BSD-2-Clause
maintainer:           Alexey Khudyakov <alexey.skladnoy@gmail.com>
author:
    Bryan O'\''Sullivan <bos@serpentine.com>,
    Alexey Khudyakov <alexey.skladnoy@gmail.com>

homepage:             https://github.com/bos/math-functions
synopsis:             Collection of tools for numeric computations
description:
    This library contain collection of various utilities for numerical
    computing. So far there'\''re special mathematical functions,
    compensated summation algorithm, summation of series, root finding
    for real functions, polynomial summation and Chebyshev
    polynomials.

category:             Math, Numeric
abi:                  0eb73a1caed611626edc35394de758c4
exposed:              True
exposed-modules:
    Numeric.MathFunctions.Comparison Numeric.MathFunctions.Constants
    Numeric.Polynomial Numeric.Polynomial.Chebyshev Numeric.RootFinding
    Numeric.Series Numeric.SpecFunctions Numeric.SpecFunctions.Extra
    Numeric.SpecFunctions.Internal Numeric.Sum

hidden-modules:       Numeric.SpecFunctions.Compat
import-dirs:          /usr/lib/ghc-9.0.1/site-local/math-functions-0.3.4.2
library-dirs:         /usr/lib/ghc-9.0.1/site-local/math-functions-0.3.4.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/math-functions-0.3.4.2
hs-libraries:         HSmath-functions-0.3.4.2-6tmWZ95gLEW2kGWXNJWTwg
depends:
    base-4.15.0.0 data-default-class-0.1.2.0-LBmwYNzg9cwLSaLiX5AQfC
    deepseq-1.4.5.0 primitive-0.7.2.0-H9HP2FbaY5C1JlRHDKja9P
    vector-0.12.3.1-HMAplmdcuCN6dtD8e6QGwL

haddock-interfaces:
    /usr/share/doc/haskell-math-functions/html/math-functions.haddock

haddock-html:         /usr/share/doc/haskell-math-functions/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

