#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 monoid-subclasses
version:              1.1.2
visibility:           public
id:                   monoid-subclasses-1.1.2-46Z2N3rHPSs5E6oOcodocw
key:                  monoid-subclasses-1.1.2-46Z2N3rHPSs5E6oOcodocw
license:              BSD-3-Clause
copyright:            (c) 2013-2021 Mario Blažević
maintainer:           Mario Blažević <blamario@protonmail.com>
author:               Mario Blažević
homepage:             https://github.com/blamario/monoid-subclasses/
synopsis:             Subclasses of Monoid
description:
    A hierarchy of subclasses of '\''Monoid'\'' together with their instances for all data structures from base, containers, and
    text packages.

category:             Data, Algebra, Text
abi:                  ed65109ff3536143e07d4b6910c8603f
exposed:              True
exposed-modules:
    Data.Monoid.Cancellative Data.Monoid.Factorial Data.Monoid.GCD
    Data.Monoid.Instances.ByteString.UTF8
    Data.Monoid.Instances.CharVector Data.Monoid.Instances.Concat
    Data.Monoid.Instances.Measured Data.Monoid.Instances.Positioned
    Data.Monoid.Instances.Stateful Data.Monoid.Monus Data.Monoid.Null
    Data.Monoid.Textual Data.Semigroup.Cancellative
    Data.Semigroup.Factorial

import-dirs:          /usr/lib/ghc-9.0.1/site-local/monoid-subclasses-1.1.2
library-dirs:         /usr/lib/ghc-9.0.1/site-local/monoid-subclasses-1.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/monoid-subclasses-1.1.2
hs-libraries:         HSmonoid-subclasses-1.1.2-46Z2N3rHPSs5E6oOcodocw
depends:
    base-4.15.0.0 bytestring-0.10.12.1 containers-0.6.4.1
    primes-0.2.1.0-Iu8oh9qtE633xEUqJauSmw text-1.2.4.1
    vector-0.12.3.1-HMAplmdcuCN6dtD8e6QGwL

haddock-interfaces:
    /usr/share/doc/haskell-monoid-subclasses/html/monoid-subclasses.haddock

haddock-html:         /usr/share/doc/haskell-monoid-subclasses/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

