#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 parameterized-utils
version:              2.1.3.0
visibility:           public
id:                   parameterized-utils-2.1.3.0-4oefTT9Pscj41668JI8m9H
key:                  parameterized-utils-2.1.3.0-4oefTT9Pscj41668JI8m9H
license:              BSD-3-Clause
copyright:            ©2016-2021 Galois, Inc.
maintainer:           jhendrix@galois.com, kquick@galois.com
author:               Galois Inc.
stability:            stable
homepage:             https://github.com/GaloisInc/parameterized-utils
synopsis:
    Classes and data structures for working with data-kind indexed types

description:
    This package contains collection classes and type representations
    used for working with values that have a single parameter.  It'\''s
    intended for things like expression libraries where one wishes
    to leverage the Haskell type-checker to improve type-safety by encoding
    the object language type system into data kinds.

category:             Data Structures, Dependent Types
abi:                  650186281e94ebca49f7982f0035c506
exposed:              True
exposed-modules:
    Data.Parameterized Data.Parameterized.All
    Data.Parameterized.BoolRepr Data.Parameterized.Classes
    Data.Parameterized.ClassesC Data.Parameterized.Compose
    Data.Parameterized.Context Data.Parameterized.Context.Safe
    Data.Parameterized.Context.Unsafe Data.Parameterized.Ctx
    Data.Parameterized.Ctx.Proofs Data.Parameterized.DataKind
    Data.Parameterized.DecidableEq Data.Parameterized.HashTable
    Data.Parameterized.List Data.Parameterized.Map
    Data.Parameterized.NatRepr Data.Parameterized.Nonce
    Data.Parameterized.Nonce.Transformers
    Data.Parameterized.Nonce.Unsafe Data.Parameterized.Pair
    Data.Parameterized.Peano Data.Parameterized.Some
    Data.Parameterized.SymbolRepr Data.Parameterized.TH.GADT
    Data.Parameterized.TraversableF Data.Parameterized.TraversableFC
    Data.Parameterized.Utils.BinTree Data.Parameterized.Utils.Endian
    Data.Parameterized.Vector Data.Parameterized.WithRepr

hidden-modules:       Data.Parameterized.NatRepr.Internal
import-dirs:          /usr/lib/ghc-9.0.1/site-local/parameterized-utils-2.1.3.0
library-dirs:         /usr/lib/ghc-9.0.1/site-local/parameterized-utils-2.1.3.0
dynamic-library-dirs: /usr/lib
data-dir:
    /usr/share/x86_64-linux-ghc-9.0.1/parameterized-utils-2.1.3.0

hs-libraries:         HSparameterized-utils-2.1.3.0-4oefTT9Pscj41668JI8m9H
depends:
    base-4.15.0.0 base-orphans-0.8.5-D2IzBuRfIFkIZ9rcTwCBsi
    constraints-0.13-7MWFMqEXLyNHc3bFX4nznn containers-0.6.4.1
    deepseq-1.4.5.0 ghc-prim-0.7.0
    hashable-1.3.4.0-IEtvls2JnYMCj5AtMjw8bF
    hashtables-1.2.4.2-9qPOqeOWa63CnwbSi2xG6U
    lens-5.0.1-E7Tul8EWHuqGCOW8gNOuPe mtl-2.2.2
    template-haskell-2.17.0.0 text-1.2.4.1
    th-abstraction-0.4.3.0-DBpnRpG8EZgFebz88L1kOA
    vector-0.12.3.1-HMAplmdcuCN6dtD8e6QGwL

haddock-interfaces:
    /usr/share/doc/haskell-parameterized-utils/html/parameterized-utils.haddock

haddock-html:         /usr/share/doc/haskell-parameterized-utils/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

