#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 postgresql-binary
version:              0.12.4.1
visibility:           public
id:                   postgresql-binary-0.12.4.1-3qYpzyHKaPm14bhaelhnwZ
key:                  postgresql-binary-0.12.4.1-3qYpzyHKaPm14bhaelhnwZ
license:              MIT
copyright:            (c) 2014, Nikita Volkov
maintainer:           Nikita Volkov <nikita.y.volkov@mail.ru>
author:               Nikita Volkov <nikita.y.volkov@mail.ru>
homepage:             https://github.com/nikita-volkov/postgresql-binary 
synopsis:             Encoders and decoders for the PostgreSQL'\''s binary format
description:
    An API for dealing with PostgreSQL'\''s binary data format.

    It can be used to implement performant bindings to Postgres.
    E.g., <http://hackage.haskell.org/package/hasql hasql>
    is based on this library.

    It supports all Postgres versions starting from 8.3
    and is tested against 8.3, 9.3 and 9.5
    with the @integer_datetimes@ setting off and on.

category:             PostgreSQL, Database, Codecs, Parsing
abi:                  34642be670a24f815a3d1b8ac0777a8d
exposed:              True
exposed-modules:
    PostgreSQL.Binary.Data PostgreSQL.Binary.Decoding
    PostgreSQL.Binary.Encoding

hidden-modules:
    PostgreSQL.Binary.Encoding.Builders PostgreSQL.Binary.Prelude
    PostgreSQL.Binary.Integral PostgreSQL.Binary.Interval
    PostgreSQL.Binary.Numeric PostgreSQL.Binary.Time
    PostgreSQL.Binary.Inet PostgreSQL.Binary.BuilderPrim

import-dirs:          /usr/lib/ghc-9.0.1/site-local/postgresql-binary-0.12.4.1
library-dirs:         /usr/lib/ghc-9.0.1/site-local/postgresql-binary-0.12.4.1
dynamic-library-dirs: /usr/lib
data-dir:
    /usr/share/x86_64-linux-ghc-9.0.1/postgresql-binary-0.12.4.1

hs-libraries:         HSpostgresql-binary-0.12.4.1-3qYpzyHKaPm14bhaelhnwZ
depends:
    aeson-1.5.6.0-FZsVpvEwT8z4bK1D26EwAs base-4.15.0.0
    binary-parser-0.5.7-HC2QtXVOwe2i6BUJwytic bytestring-0.10.12.1
    bytestring-strict-builder-0.4.5.4-JwI8I262yt35iBh1vwQpxa
    containers-0.6.4.1 network-ip-0.3.0.3-HHxvR2zb9QM8qDLbSw6gtm
    scientific-0.3.7.0-80Xt5iXHAGIBd7njyVx1yZ text-1.2.4.1 time-1.9.3
    transformers-0.5.6.2
    unordered-containers-0.2.14.0-7Twq3Q78XsnAV2eREMKYwX
    uuid-1.3.15-CqqeGHsi76c5zqF2MOLAcg
    vector-0.12.3.1-HMAplmdcuCN6dtD8e6QGwL

haddock-interfaces:
    /usr/share/doc/haskell-postgresql-binary/html/postgresql-binary.haddock

haddock-html:         /usr/share/doc/haskell-postgresql-binary/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

