#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 quickcheck-classes
version:              0.6.5.0
visibility:           public
id:                   quickcheck-classes-0.6.5.0-7Hms7YkTIFx8CRwubMr0vd
key:                  quickcheck-classes-0.6.5.0-7Hms7YkTIFx8CRwubMr0vd
license:              BSD-3-Clause
copyright:            2018 Andrew Martin
maintainer:           andrew.thaddeus@gmail.com
author:               Andrew Martin, chessai
homepage:             https://github.com/andrewthad/quickcheck-classes#readme
synopsis:             QuickCheck common typeclasses
description:
    This library provides QuickCheck properties to ensure
    that typeclass instances adhere to the set of laws that
    they are supposed to. There are other libraries that do
    similar things, such as `genvalidity-hspec` and `checkers`.
    This library differs from other solutions by not introducing
    any new typeclasses that the user needs to learn.

    /Note:/ on GHC < 8.5, this library uses the higher-kinded typeclasses
    ('\''Data.Functor.Classes.Show1'\'', '\''Data.Functor.Classes.Eq1'\'', '\''Data.Functor.Classes.Ord1'\'', etc.),
    but on GHC >= 8.5, it uses `-XQuantifiedConstraints` to express these
    constraints more cleanly.

category:             Testing
abi:                  268642160d903e9c35d6dc43029cfbfe
exposed:              True
exposed-modules:
    Test.QuickCheck.Classes Test.QuickCheck.Classes.IsList

hidden-modules:
    Test.QuickCheck.Classes.Alt Test.QuickCheck.Classes.Apply
    Test.QuickCheck.Classes.Euclidean Test.QuickCheck.Classes.Json
    Test.QuickCheck.Classes.MVector Test.QuickCheck.Classes.Plus
    Test.QuickCheck.Classes.Prim Test.QuickCheck.Classes.Semigroupoid
    Test.QuickCheck.Classes.Semiring Test.QuickCheck.Classes.Ring

import-dirs:          /usr/lib/ghc-9.0.1/site-local/quickcheck-classes-0.6.5.0
library-dirs:         /usr/lib/ghc-9.0.1/site-local/quickcheck-classes-0.6.5.0
dynamic-library-dirs: /usr/lib
data-dir:
    /usr/share/x86_64-linux-ghc-9.0.1/quickcheck-classes-0.6.5.0

hs-libraries:         HSquickcheck-classes-0.6.5.0-7Hms7YkTIFx8CRwubMr0vd
depends:
    QuickCheck-2.14.2-3f9Gw3UEGqTK3AyHIcW3dz
    aeson-1.5.6.0-FZsVpvEwT8z4bK1D26EwAs base-4.15.0.0
    containers-0.6.4.1 primitive-0.7.2.0-H9HP2FbaY5C1JlRHDKja9P
    primitive-addr-0.1.0.2-7c91VUS0zrxGq6I11hHGGL
    quickcheck-classes-base-0.6.2.0-56OEhr55LLfLIGYYejRTiO
    semigroupoids-5.3.6-JFZbW6XT2Qu838ghLJLro6
    semirings-0.6-2KIhyGdincC3T3R8liKfc3 transformers-0.5.6.2
    vector-0.12.3.1-HMAplmdcuCN6dtD8e6QGwL

haddock-interfaces:
    /usr/share/doc/haskell-quickcheck-classes/html/quickcheck-classes.haddock

haddock-html:         /usr/share/doc/haskell-quickcheck-classes/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

