#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 regex-tdfa
version:              1.3.1.1
visibility:           public
id:                   regex-tdfa-1.3.1.1-JysT5HHQf7SDqagoTfdJw
key:                  regex-tdfa-1.3.1.1-JysT5HHQf7SDqagoTfdJw
license:              BSD-3-Clause
copyright:            Copyright (c) 2007-2009, Christopher Kuklewicz
maintainer:
    Herbert Valerio Riedel <hvr@gnu.org>,
    Andreas Abel

author:               Christopher Kuklewicz
homepage:             https://wiki.haskell.org/Regular_expressions
synopsis:
    Pure Haskell Tagged DFA Backend for "Text.Regex" (regex-base)

description:
    This package provides a pure Haskell \"Tagged\" DFA regex engine for <//hackage.haskell.org/package/regex-base regex-base>. This implementation was inspired by the algorithm (and Master'\''s thesis) behind the regular expression library known as <https://github.com/laurikari/tre/ TRE or libtre>.

    Please consult the "Text.Regex.TDFA" module for API documentation including a tutorial with usage examples;
    see also <https://wiki.haskell.org/Regular_expressions> for general information about regular expression support in Haskell.

category:             Text
abi:                  b4c47c9059012657c022ed05336001fc
exposed:              True
exposed-modules:
    Data.IntMap.CharMap2 Data.IntMap.EnumMap2 Data.IntSet.EnumSet2
    Text.Regex.TDFA Text.Regex.TDFA.ByteString
    Text.Regex.TDFA.ByteString.Lazy Text.Regex.TDFA.Common
    Text.Regex.TDFA.CorePattern Text.Regex.TDFA.IntArrTrieSet
    Text.Regex.TDFA.NewDFA.Engine Text.Regex.TDFA.NewDFA.Engine_FA
    Text.Regex.TDFA.NewDFA.Engine_NC
    Text.Regex.TDFA.NewDFA.Engine_NC_FA Text.Regex.TDFA.NewDFA.MakeTest
    Text.Regex.TDFA.NewDFA.Tester Text.Regex.TDFA.NewDFA.Uncons
    Text.Regex.TDFA.Pattern Text.Regex.TDFA.ReadRegex
    Text.Regex.TDFA.Sequence Text.Regex.TDFA.String
    Text.Regex.TDFA.TDFA Text.Regex.TDFA.TNFA Text.Regex.TDFA.Text
    Text.Regex.TDFA.Text.Lazy

hidden-modules:       Paths_regex_tdfa
import-dirs:          /usr/lib/ghc-9.0.1/site-local/regex-tdfa-1.3.1.1
library-dirs:         /usr/lib/ghc-9.0.1/site-local/regex-tdfa-1.3.1.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/regex-tdfa-1.3.1.1
hs-libraries:         HSregex-tdfa-1.3.1.1-JysT5HHQf7SDqagoTfdJw
depends:
    array-0.5.4.0 base-4.15.0.0 bytestring-0.10.12.1 containers-0.6.4.1
    mtl-2.2.2 parsec-3.1.14.0
    regex-base-0.94.0.2-1zsBt75PqJm7HZsEZt0j76 text-1.2.4.1

haddock-interfaces:   /usr/share/doc/haskell-regex-tdfa/html/regex-tdfa.haddock
haddock-html:         /usr/share/doc/haskell-regex-tdfa/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

