#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 retrie
version:              1.0.0.0
visibility:           public
id:                   retrie-1.0.0.0-DbaYgJQXkckFE6dSzApuJ9
key:                  retrie-1.0.0.0-DbaYgJQXkckFE6dSzApuJ9
license:              MIT
copyright:            Copyright (c) Facebook, Inc. and its affiliates.
maintainer:           Andrew Farmer <anfarmer@fb.com>
author:               Andrew Farmer <anfarmer@fb.com>
homepage:             https://github.com/facebookincubator/retrie
synopsis:             A powerful, easy-to-use codemodding tool for Haskell.
description:
    Retrie is a tool for codemodding Haskell. Key goals include:

    * Speed: Efficiently rewrite in large (>1 million line) codebases.
    * Safety: Avoids large classes of codemod-related errors.
    * Ease-of-use: Haskell syntax instead of regular expressions. No hand-rolled AST traversals.

    This package provides a command-line tool (@retrie@) and a library
    ("Retrie") for making equational edits to Haskell code.

    Please see the [README](#readme) for examples and usage.

category:             Development
abi:                  92945d47695a3ef37ce80b41354c98dc
exposed:              True
exposed-modules:
    Retrie Retrie.AlphaEnv Retrie.CPP Retrie.Context Retrie.Debug
    Retrie.ExactPrint Retrie.ExactPrint.Annotated Retrie.Expr
    Retrie.Fixity Retrie.FreeVars Retrie.GHC Retrie.GroundTerms
    Retrie.Monad Retrie.Options Retrie.PatternMap.Bag
    Retrie.PatternMap.Class Retrie.PatternMap.Instances Retrie.Pretty
    Retrie.Quantifiers Retrie.Query Retrie.Replace Retrie.Rewrites
    Retrie.Rewrites.Function Retrie.Rewrites.Patterns
    Retrie.Rewrites.Rules Retrie.Rewrites.Types Retrie.Run Retrie.SYB
    Retrie.Subst Retrie.Substitution Retrie.Types Retrie.Universe
    Retrie.Util

import-dirs:          /usr/lib/ghc-9.0.1/site-local/retrie-1.0.0.0
library-dirs:         /usr/lib/ghc-9.0.1/site-local/retrie-1.0.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/retrie-1.0.0.0
hs-libraries:         HSretrie-1.0.0.0-DbaYgJQXkckFE6dSzApuJ9
depends:
    ansi-terminal-0.11-DOUngjGM5e9DBdxKKdJoVq
    async-2.2.3-9hcO3XZAP863cAPa5inA8N base-4.15.0.0
    bytestring-0.10.12.1 containers-0.6.4.1
    data-default-0.7.1.1-5RJjHNv19ESJeD93LU2jRn directory-1.3.6.1
    filepath-1.4.2.1 ghc-9.0.1
    ghc-exactprint-0.6.4-GR4LvEur6522rTYZTO2hSh mtl-2.2.2
    optparse-applicative-0.16.1.0-Hmp4enGFORO7G3xu1QJ5as
    process-1.6.11.0 random-shuffle-0.0.4-4MzTKTkvKP8E3v33cGUsyP
    syb-0.7.2.1-1KAKIfi7jVfHb7rx2ko4wD text-1.2.4.1
    transformers-0.5.6.2
    unordered-containers-0.2.14.0-7Twq3Q78XsnAV2eREMKYwX

haddock-interfaces:   /usr/share/doc/haskell-retrie/html/retrie.haddock
haddock-html:         /usr/share/doc/haskell-retrie/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

