#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 scotty
version:              0.12
visibility:           public
id:                   scotty-0.12-2TlDSgbtZbODCm9ZMo1usD
key:                  scotty-0.12-2TlDSgbtZbODCm9ZMo1usD
license:              BSD-3-Clause
copyright:            (c) 2012-Present Andrew Farmer
maintainer:           Andrew Farmer <xichekolas@gmail.com>
author:               Andrew Farmer <xichekolas@gmail.com>
stability:            experimental
homepage:             https://github.com/scotty-web/scotty
synopsis:
    Haskell web framework inspired by Ruby'\''s Sinatra, using WAI and Warp

description:
    A Haskell web framework inspired by Ruby'\''s Sinatra, using WAI and Warp.

    @
    &#123;-&#35; LANGUAGE OverloadedStrings &#35;-&#125;

    import Web.Scotty

    import Data.Monoid (mconcat)

    main = scotty 3000 $
    &#32;&#32;get &#34;/:word&#34; $ do
    &#32;&#32;&#32;&#32;beam <- param &#34;word&#34;
    &#32;&#32;&#32;&#32;html $ mconcat [&#34;&#60;h1&#62;Scotty, &#34;, beam, &#34; me up!&#60;/h1&#62;&#34;]
    @


    Scotty is the cheap and cheerful way to write RESTful, declarative web applications.

    * A page is as simple as defining the verb, url pattern, and Text content.

    * It is template-language agnostic. Anything that returns a Text value will do.

    * Conforms to WAI Application interface.

    * Uses very fast Warp webserver by default.

    As for the name: Sinatra + Warp = Scotty.

    [WAI] <http://hackage.haskell.org/package/wai>

    [Warp] <http://hackage.haskell.org/package/warp>

category:             Web
abi:                  94fe0eb0a20c2b9b7d5280fb05a6244b
exposed:              True
exposed-modules:      Web.Scotty Web.Scotty.Internal.Types Web.Scotty.Trans
hidden-modules:       Web.Scotty.Action Web.Scotty.Route Web.Scotty.Util
import-dirs:          /usr/lib/ghc-9.0.1/site-local/scotty-0.12
library-dirs:         /usr/lib/ghc-9.0.1/site-local/scotty-0.12
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/scotty-0.12
hs-libraries:         HSscotty-0.12-2TlDSgbtZbODCm9ZMo1usD
depends:
    aeson-1.5.6.0-FZsVpvEwT8z4bK1D26EwAs base-4.15.0.0
    base-compat-batteries-0.11.2-Cs6UiKAcT2NJzvnx9vzluN
    blaze-builder-0.4.2.2-Iw4q9HoGXXULmCBD2udQGP bytestring-0.10.12.1
    case-insensitive-1.2.1.0-810KinvQcYx7xuCoSIHpwY
    data-default-class-0.1.2.0-LBmwYNzg9cwLSaLiX5AQfC exceptions-0.10.4
    http-types-0.12.3-J3pS8fDTy4j62mHquuNqa5
    monad-control-1.0.3.1-buqreaszgTDhqS64rvHY6 mtl-2.2.2
    network-3.1.2.2-HXcjy5szECnDN1PS9jNchP
    regex-compat-0.95.2.1-BYf5MzDvacc20KBqPh3t2u text-1.2.4.1
    transformers-0.5.6.2 transformers-base-0.4.6-BxowhPHAvTf3506d7p3ISW
    transformers-compat-0.7.1-27E2wCklav6CMkj1Ns7rzE
    wai-3.2.3-GecSYae22qn12CDRauoVPu
    wai-extra-3.1.7-B23YpUDkXJKJRUMohg3vbP
    warp-3.3.18-Ju7KtFd4F0Y6iraztNvj3R

haddock-interfaces:   /usr/share/doc/haskell-scotty/html/scotty.haddock
haddock-html:         /usr/share/doc/haskell-scotty/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

