#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 servant-swagger
version:              1.1.10
visibility:           public
id:                   servant-swagger-1.1.10-CT3XW8KlDzf546GeyE3yov
key:                  servant-swagger-1.1.10-CT3XW8KlDzf546GeyE3yov
license:              BSD-3-Clause
copyright:            (c) 2015-2018, Servant contributors
maintainer:           nickolay.kudasov@gmail.com
author:               David Johnson, Nickolay Kudasov
homepage:             https://github.com/haskell-servant/servant-swagger
synopsis:
    Generate a Swagger/OpenAPI/OAS 2.0 specification for your servant API.

description:
    Swagger is a project used to describe and document RESTful APIs. The core of the
    project is the [OpenAPI Specification (OAS)](https://swagger.io/docs/specification/about/).
    This library implements v2.0 of the spec. Unlike Servant it is language-agnostic and thus is
    quite popular among developers in different languages. It has also existed for a longer time
    and has more helpful tooling.

    This package provides means to generate a Swagger/OAS specification for a Servant API
    and also to partially test whether an API conforms with its specification.

    Generated Swagger specification then can be used for many things such as

    * displaying interactive documentation using [Swagger UI](http://swagger.io/swagger-ui/);

    * generating clients and servers in many languages using [Swagger Codegen](http://swagger.io/swagger-codegen/);

    * and [many others](http://swagger.io/open-source-integrations/).

category:             Web, Servant, Swagger
abi:                  73869fc9fcd43d952cbcf06d9f6a1de6
exposed:              True
exposed-modules:
    Servant.Swagger Servant.Swagger.Internal
    Servant.Swagger.Internal.Orphans Servant.Swagger.Internal.Test
    Servant.Swagger.Internal.TypeLevel
    Servant.Swagger.Internal.TypeLevel.API
    Servant.Swagger.Internal.TypeLevel.Every
    Servant.Swagger.Internal.TypeLevel.TMap Servant.Swagger.Test
    Servant.Swagger.TypeLevel

import-dirs:          /usr/lib/ghc-9.0.1/site-local/servant-swagger-1.1.10
library-dirs:         /usr/lib/ghc-9.0.1/site-local/servant-swagger-1.1.10
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/servant-swagger-1.1.10
hs-libraries:         HSservant-swagger-1.1.10-CT3XW8KlDzf546GeyE3yov
depends:
    QuickCheck-2.14.2-3f9Gw3UEGqTK3AyHIcW3dz
    aeson-1.5.6.0-FZsVpvEwT8z4bK1D26EwAs
    aeson-pretty-0.8.9-4VpDxWXnDJA8Bu2hhX3Ado base-4.15.0.0
    base-compat-0.11.2-EfuzzJ3SbjR74eBdJgKfBC bytestring-0.10.12.1
    hspec-2.8.3-LtRJwH8U2CkLRWWgrrKPIl
    http-media-0.8.0.0-FhKzgr2UAXdBnqKQF0J9O8
    insert-ordered-containers-0.2.5-5Wqo7nOOBLG4pPsgEvb3wt
    lens-5.0.1-E7Tul8EWHuqGCOW8gNOuPe
    servant-0.18.3-1XqwkckqzIP8FdXKUwOeuS
    singleton-bool-0.1.6-HMd8b5o9srcKE3b88hhcU5
    swagger2-2.6.1-2BszI4THdo9HLJ36AxYPVq text-1.2.4.1
    unordered-containers-0.2.14.0-7Twq3Q78XsnAV2eREMKYwX

haddock-interfaces:
    /usr/share/doc/haskell-servant-swagger/html/servant-swagger.haddock

haddock-html:         /usr/share/doc/haskell-servant-swagger/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

