#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 shelly
version:              1.9.0
visibility:           public
id:                   shelly-1.9.0-LS0wjSYaWvk1517XHZkCMp
key:                  shelly-1.9.0-LS0wjSYaWvk1517XHZkCMp
license:              BSD-3-Clause
maintainer:           Greg Weber <greg@gregweber.info>
author:               Greg Weber, Petr Rockai
homepage:             https://github.com/yesodweb/Shelly.hs
synopsis:             shell-like (systems) programming in Haskell
description:
    Shelly provides convenient systems programming in Haskell,
    similar in spirit to POSIX shells. Shelly:

    * is aimed at convenience and getting things done rather than
    being a demonstration of elegance.

    * has detailed and useful error messages

    * maintains its own environment, making it thread-safe.

    * is modern, using Text filepath/directory

    Shelly is originally forked from the Shellish package.

    See the shelly-extra package for additional functionality.

    An overview is available in the README: <https://github.com/yesodweb/Shelly.hs/blob/master/README.md>

category:             Development
abi:                  690c51ef697627fbaaa0bc3055314023
exposed:              True
exposed-modules:      Shelly Shelly.Lifted Shelly.Pipe Shelly.Unix
hidden-modules:       Shelly.Base Shelly.Find Shelly.Directory
import-dirs:          /usr/lib/ghc-9.0.1/site-local/shelly-1.9.0
library-dirs:         /usr/lib/ghc-9.0.1/site-local/shelly-1.9.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/shelly-1.9.0
hs-libraries:         HSshelly-1.9.0-LS0wjSYaWvk1517XHZkCMp
depends:
    async-2.2.3-9hcO3XZAP863cAPa5inA8N base-4.15.0.0
    bytestring-0.10.12.1 containers-0.6.4.1 directory-1.3.6.1
    enclosed-exceptions-1.0.3-GQu2YxCnkUoDuXLZgWX9hA exceptions-0.10.4
    filepath-1.4.2.1 lifted-async-0.10.2.1-Asb38MEK19gEDVjtmHIBjY
    lifted-base-0.2.3.12-ADDJP4xnM4QFstKYdEacPI
    monad-control-1.0.3.1-buqreaszgTDhqS64rvHY6 mtl-2.2.2
    process-1.6.11.0 text-1.2.4.1 time-1.9.3 transformers-0.5.6.2
    transformers-base-0.4.6-BxowhPHAvTf3506d7p3ISW unix-2.7.2.2
    unix-compat-0.5.3-CsWJk3UHZrh7lbWn5tdOhn

haddock-interfaces:   /usr/share/doc/haskell-shelly/html/shelly.haddock
haddock-html:         /usr/share/doc/haskell-shelly/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

