#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 statistics
version:              0.15.2.0
visibility:           public
id:                   statistics-0.15.2.0-BTCs5TPA16e490UtaQXKyo
key:                  statistics-0.15.2.0-BTCs5TPA16e490UtaQXKyo
license:              BSD-2-Clause
copyright:            2009-2014 Bryan O'\''Sullivan
maintainer:
    Bryan O'\''Sullivan <bos@serpentine.com>, Alexey Khudaykov <alexey.skladnoy@gmail.com>

author:
    Bryan O'\''Sullivan <bos@serpentine.com>, Alexey Khudaykov <alexey.skladnoy@gmail.com>

homepage:             https://github.com/bos/statistics
synopsis:             A library of statistical types, data, and functions
description:
    This library provides a number of common functions and types useful
    in statistics.  We focus on high performance, numerical robustness,
    and use of good algorithms.  Where possible, we provide
    references to the statistical literature.

    The library'\''s facilities can be divided into four broad categories:

    * Working with widely used discrete and continuous probability
    distributions.  (There are dozens of exotic distributions in use;
    we focus on the most common.)

    * Computing with sample data: quantile estimation, kernel density
    estimation, histograms, bootstrap methods, significance testing,
    and regression and autocorrelation analysis.

    * Random variate generation under several different distributions.

    * Common statistical tests for significant differences between
    samples.

category:             Math, Statistics
abi:                  a39baee2db8831fedf6e33261c4c2b4b
exposed:              True
exposed-modules:
    Statistics.Autocorrelation Statistics.ConfidenceInt
    Statistics.Correlation Statistics.Correlation.Kendall
    Statistics.Distribution Statistics.Distribution.Beta
    Statistics.Distribution.Binomial
    Statistics.Distribution.CauchyLorentz
    Statistics.Distribution.ChiSquared
    Statistics.Distribution.DiscreteUniform
    Statistics.Distribution.Exponential
    Statistics.Distribution.FDistribution Statistics.Distribution.Gamma
    Statistics.Distribution.Geometric
    Statistics.Distribution.Hypergeometric
    Statistics.Distribution.Laplace Statistics.Distribution.Normal
    Statistics.Distribution.Poisson Statistics.Distribution.StudentT
    Statistics.Distribution.Transform Statistics.Distribution.Uniform
    Statistics.Function Statistics.Quantile Statistics.Regression
    Statistics.Resampling Statistics.Resampling.Bootstrap
    Statistics.Sample Statistics.Sample.Histogram
    Statistics.Sample.Internal Statistics.Sample.KernelDensity
    Statistics.Sample.KernelDensity.Simple Statistics.Sample.Normalize
    Statistics.Sample.Powers Statistics.Test.ChiSquared
    Statistics.Test.KolmogorovSmirnov Statistics.Test.KruskalWallis
    Statistics.Test.MannWhitneyU Statistics.Test.StudentT
    Statistics.Test.Types Statistics.Test.WilcoxonT
    Statistics.Transform Statistics.Types

hidden-modules:
    Statistics.Distribution.Poisson.Internal Statistics.Internal
    Statistics.Test.Internal Statistics.Types.Internal

import-dirs:          /usr/lib/ghc-9.0.1/site-local/statistics-0.15.2.0
library-dirs:         /usr/lib/ghc-9.0.1/site-local/statistics-0.15.2.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/statistics-0.15.2.0
hs-libraries:         HSstatistics-0.15.2.0-BTCs5TPA16e490UtaQXKyo
depends:
    aeson-1.5.6.0-FZsVpvEwT8z4bK1D26EwAs
    async-2.2.3-9hcO3XZAP863cAPa5inA8N base-4.15.0.0
    base-orphans-0.8.5-D2IzBuRfIFkIZ9rcTwCBsi binary-0.8.8.0
    data-default-class-0.1.2.0-LBmwYNzg9cwLSaLiX5AQfC deepseq-1.4.5.0
    dense-linear-algebra-0.1.0.0-GpdIS1fgTpb11b7kRbmZix
    math-functions-0.3.4.2-6tmWZ95gLEW2kGWXNJWTwg
    monad-par-0.3.5-9Yy6GzkQPfgICzMy8JRrcF
    mwc-random-0.15.0.2-B74lQS5KSNZ61DdWIu57KK
    primitive-0.7.2.0-H9HP2FbaY5C1JlRHDKja9P
    vector-0.12.3.1-HMAplmdcuCN6dtD8e6QGwL
    vector-algorithms-0.8.0.4-GADaz9rwMd2vseP5sgOfY
    vector-binary-instances-0.2.5.2-20zf7Gm3C4DADIkedFqC2R
    vector-th-unbox-0.2.2-3mZffNjRCOWL6aQ9HkZPmL

haddock-interfaces:   /usr/share/doc/haskell-statistics/html/statistics.haddock
haddock-html:         /usr/share/doc/haskell-statistics/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

