#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 tamarin-prover-sapic
version:              1.6.1
visibility:           public
id:                   tamarin-prover-sapic-1.6.1-FJC0BiCA9V06wAm5WB4FmQ
key:                  tamarin-prover-sapic-1.6.1-FJC0BiCA9V06wAm5WB4FmQ
license:              LicenseRef-GPL
copyright:
    Robert Künnemann, Alexander Dax, CISPA-Helmholtz-Centre Saarbrücken, 2019

maintainer:           Robert Künnemann <robert@kunnemann.de>
author:
    Robert Künnemann <robert@kunnemann.de>,
    Alexander Dax <alexander.dax@cispa.saarland>

homepage:             https://tamarin-prover.github.io/
synopsis:
    Library for input processes in SAPIC calculus for the tamarin prover.

description:
    This is an internal library of the Tamarin prover for
    security protocol verification
    (<hackage.haskell.org/package/tamarin-prover>).

    This library provides a translation from processes stated in the SAPIC calculus into multiset rewrite rules.

category:             Theorem Provers
abi:                  49f73a2ba0e6feface5f5ba05b574a4a
exposed:              True
exposed-modules:
    Sapic Sapic.Annotation Sapic.Basetranslation Sapic.Exceptions
    Sapic.Facts Sapic.Locks Sapic.ProcessUtils Sapic.ProgressFunction
    Sapic.ProgressTranslation Sapic.ReliableChannelTranslation
    Sapic.Report Sapic.SecretChannels

import-dirs:          /usr/lib/ghc-9.0.1/site-local/tamarin-prover-sapic-1.6.1
library-dirs:         /usr/lib/ghc-9.0.1/site-local/tamarin-prover-sapic-1.6.1
dynamic-library-dirs: /usr/lib
data-dir:
    /usr/share/x86_64-linux-ghc-9.0.1/tamarin-prover-sapic-1.6.1

hs-libraries:         HStamarin-prover-sapic-1.6.1-FJC0BiCA9V06wAm5WB4FmQ
depends:
    aeson-1.5.6.0-FZsVpvEwT8z4bK1D26EwAs
    aeson-pretty-0.8.9-4VpDxWXnDJA8Bu2hhX3Ado base-4.15.0.0
    binary-0.8.8.0 bytestring-0.10.12.1 containers-0.6.4.1
    deepseq-1.4.5.0 dlist-1.0-DqtNBE1aXOzH1lBPsXifRQ exceptions-0.10.4
    fclabels-2.0.5.1-HkJnaBmqf40GXOlYXDVrbR mtl-2.2.2
    parallel-3.2.2.0-G9JTeCQCHda2yggytvFxi6 parsec-3.1.14.0
    process-1.6.11.0 raw-strings-qq-1.1-CLXcZ6xZs1MBdVueQzMB5f
    safe-0.3.19-BCcHjTM7bV690cTfMWPidj
    tamarin-prover-term-1.6.1-K3AW4Q0mq3Uxts6NT8Gyi
    tamarin-prover-theory-1.6.1-5o94GfKWm6p8ans3hrgN3j
    tamarin-prover-utils-1.6.1-2i5RnAyoezWCCYMqMQPmyY text-1.2.4.1
    transformers-0.5.6.2 uniplate-1.6.13-2uz31erAwds7VFkT8cOsFY

haddock-interfaces:
    /usr/share/doc/haskell-tamarin-prover-sapic/html/tamarin-prover-sapic.haddock

haddock-html:         /usr/share/doc/haskell-tamarin-prover-sapic/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

