#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 tamarin-prover-term
version:              1.6.1
visibility:           public
id:                   tamarin-prover-term-1.6.1-K3AW4Q0mq3Uxts6NT8Gyi
key:                  tamarin-prover-term-1.6.1-K3AW4Q0mq3Uxts6NT8Gyi
license:              LicenseRef-GPL
copyright:
    Benedikt Schmidt, Simon Meier, Jannik Dreier, Ralf Sasse, ETH Zurich, 2010-2018

maintainer:
    Simon Meier <simon.meier@inf.ethz.ch>,
    Jannik Dreier <research@jannikdreier.net>,
    Ralf Sasse <ralf.sasse@gmail.com>

author:
    Benedikt Schmidt <benedikt.schmidt@inf.ethz.ch>,
    Simon Meier <simon.meier@inf.ethz.ch>,
    Jannik Dreier <research@jannikdreier.net>,
    Ralf Sasse <ralf.sasse@gmail.com>

homepage:             https://tamarin-prover.github.io/
synopsis:             Term manipulation library for the tamarin prover.
description:
    This is an internal library of the Tamarin prover for
    security protocol verification
    (<hackage.haskell.org/package/tamarin-prover>).

    This library provides term manipulation infrastructure
    (matching, unification, narrowing, finite variants) for
    the Tamarin prover. It uses maude
    (<http://maude.cs.uiuc.edu/>) as a backend for
    normalization, equational matching, and unification.

category:             Theorem Provers
abi:                  d51b35df350779f0d4aa0da4d9e70657
exposed:              True
exposed-modules:
    Term.Builtin.Convenience Term.Builtin.Rules Term.Builtin.Signature
    Term.LTerm Term.Maude.Parser Term.Maude.Process
    Term.Maude.Signature Term.Maude.Types Term.Narrowing.Variants
    Term.Narrowing.Variants.Check Term.Narrowing.Variants.Compute
    Term.Positions Term.Rewriting.Definitions Term.Rewriting.Norm
    Term.Substitution Term.Subsumption Term.SubtermRule
    Term.Unification Term.UnitTests Term.VTerm

hidden-modules:
    Term.Term Term.Term.Classes Term.Term.Raw Term.Term.FunctionSymbols
    Term.Narrowing.Narrow Term.Substitution.SubstVFree
    Term.Substitution.SubstVFresh

import-dirs:          /usr/lib/ghc-9.0.1/site-local/tamarin-prover-term-1.6.1
library-dirs:         /usr/lib/ghc-9.0.1/site-local/tamarin-prover-term-1.6.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/tamarin-prover-term-1.6.1
hs-libraries:         HStamarin-prover-term-1.6.1-K3AW4Q0mq3Uxts6NT8Gyi
depends:
    HUnit-1.6.2.0-2lDDmQCEetY9OrwZ2lDZMS
    attoparsec-0.14.1-B8P567zH1pOF107V9enGUK base-4.15.0.0
    binary-0.8.8.0 bytestring-0.10.12.1 containers-0.6.4.1
    deepseq-1.4.5.0 dlist-1.0-DqtNBE1aXOzH1lBPsXifRQ mtl-2.2.2
    process-1.6.11.0 safe-0.3.19-BCcHjTM7bV690cTfMWPidj
    tamarin-prover-utils-1.6.1-2i5RnAyoezWCCYMqMQPmyY

haddock-interfaces:
    /usr/share/doc/haskell-tamarin-prover-term/html/tamarin-prover-term.haddock

haddock-html:         /usr/share/doc/haskell-tamarin-prover-term/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

