#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 tamarin-prover-theory
version:              1.6.1
visibility:           public
id:                   tamarin-prover-theory-1.6.1-5o94GfKWm6p8ans3hrgN3j
key:                  tamarin-prover-theory-1.6.1-5o94GfKWm6p8ans3hrgN3j
license:              LicenseRef-GPL
copyright:
    Benedikt Schmidt, Simon Meier, Jannik Dreier, Ralf Sasse, ETH Zurich, 2010-2018

maintainer:
    Simon Meier <simon.meier@inf.ethz.ch>,
    Jannik Dreier <research@jannikdreier.net>,
    Ralf Sasse <ralf.sasse@gmail.com>

author:
    Benedikt Schmidt <benedikt.schmidt@inf.ethz.ch>,
    Simon Meier <simon.meier@inf.ethz.ch>,
    Jannik Dreier <research@jannikdreier.net>,
    Ralf Sasse <ralf.sasse@gmail.com>

homepage:             https://tamarin-prover.github.io/
synopsis:
    Security protocol types and constraint solver library for the tamarin prover.

description:
    This is an internal library of the Tamarin prover for
    security protocol verification
    (<hackage.haskell.org/package/tamarin-prover>).

    This library provides the types to represent security
    protocols, and it implements the constraint solver.

category:             Theorem Provers
abi:                  3b3383d69a586e9e0312dbac65faa28f
exposed:              True
exposed-modules:
    Theory Theory.Constraint.Solver
    Theory.Constraint.Solver.Contradictions
    Theory.Constraint.Solver.Goals Theory.Constraint.Solver.Heuristics
    Theory.Constraint.Solver.ProofMethod
    Theory.Constraint.Solver.Reduction
    Theory.Constraint.Solver.Simplify Theory.Constraint.Solver.Sources
    Theory.Constraint.System Theory.Constraint.System.Constraints
    Theory.Constraint.System.Dot Theory.Constraint.System.Guarded
    Theory.Constraint.System.JSON Theory.Model Theory.Model.Atom
    Theory.Model.Fact Theory.Model.Formula Theory.Model.Restriction
    Theory.Model.Rule Theory.Model.Signature Theory.Proof Theory.Sapic
    Theory.Sapic.Print Theory.Text.Parser
    Theory.Text.Parser.Restriction Theory.Text.Parser.Token
    Theory.Text.Pretty Theory.Tools.AbstractInterpretation
    Theory.Tools.EquationStore Theory.Tools.InjectiveFactInstances
    Theory.Tools.IntruderRules Theory.Tools.LoopBreakers
    Theory.Tools.RuleVariants Theory.Tools.Wellformedness

hidden-modules:
    Theory.Text.Parser.Exceptions Theory.Text.Parser.Fact
    Theory.Text.Parser.Formula Theory.Text.Parser.Lemma
    Theory.Text.Parser.Let Theory.Text.Parser.Proof
    Theory.Text.Parser.Rule Theory.Text.Parser.Sapic
    Theory.Text.Parser.Signature Theory.Text.Parser.Term

import-dirs:          /usr/lib/ghc-9.0.1/site-local/tamarin-prover-theory-1.6.1
library-dirs:         /usr/lib/ghc-9.0.1/site-local/tamarin-prover-theory-1.6.1
dynamic-library-dirs: /usr/lib
data-dir:
    /usr/share/x86_64-linux-ghc-9.0.1/tamarin-prover-theory-1.6.1

hs-libraries:         HStamarin-prover-theory-1.6.1-5o94GfKWm6p8ans3hrgN3j
depends:
    aeson-1.5.6.0-FZsVpvEwT8z4bK1D26EwAs
    aeson-pretty-0.8.9-4VpDxWXnDJA8Bu2hhX3Ado base-4.15.0.0
    binary-0.8.8.0 bytestring-0.10.12.1 containers-0.6.4.1
    deepseq-1.4.5.0 dlist-1.0-DqtNBE1aXOzH1lBPsXifRQ exceptions-0.10.4
    fclabels-2.0.5.1-HkJnaBmqf40GXOlYXDVrbR filepath-1.4.2.1 mtl-2.2.2
    parallel-3.2.2.0-G9JTeCQCHda2yggytvFxi6 parsec-3.1.14.0
    process-1.6.11.0 safe-0.3.19-BCcHjTM7bV690cTfMWPidj
    tamarin-prover-term-1.6.1-K3AW4Q0mq3Uxts6NT8Gyi
    tamarin-prover-utils-1.6.1-2i5RnAyoezWCCYMqMQPmyY text-1.2.4.1
    transformers-0.5.6.2 uniplate-1.6.13-2uz31erAwds7VFkT8cOsFY

haddock-interfaces:
    /usr/share/doc/haskell-tamarin-prover-theory/html/tamarin-prover-theory.haddock

haddock-html:         /usr/share/doc/haskell-tamarin-prover-theory/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

