#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 tdigest
version:              0.2.1.1
visibility:           public
id:                   tdigest-0.2.1.1-K4kwzeE0H7a9LuCZaLzOci
key:                  tdigest-0.2.1.1-K4kwzeE0H7a9LuCZaLzOci
license:              BSD-3-Clause
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/haskell-tdigest#readme
synopsis:             On-line accumulation of rank-based statistics
description:
    A new data structure for accurate on-line accumulation of rank-based statistics such as quantiles and trimmed means.

    See original paper: "Computing extremely accurate quantiles using t-digest" by Ted Dunning and Otmar Ertl
    for more details <https://github.com/tdunning/t-digest/blob/07b8f2ca2be8d0a9f04df2feadad5ddc1bb73c88/docs/t-digest-paper/histo.pdf>.

category:             Numeric
abi:                  5b0f853c5cbd74b2a969945292f1f97b
exposed:              True
exposed-modules:
    Data.TDigest Data.TDigest.Internal Data.TDigest.NonEmpty
    Data.TDigest.Postprocess Data.TDigest.Postprocess.Internal
    Data.TDigest.Tree Data.TDigest.Tree.Internal
    Data.TDigest.Tree.NonEmpty Data.TDigest.Tree.Postprocess
    Data.TDigest.Vector Data.TDigest.Vector.Internal
    Data.TDigest.Vector.NonEmpty Data.TDigest.Vector.Postprocess

import-dirs:          /usr/lib/ghc-9.0.1/site-local/tdigest-0.2.1.1
library-dirs:         /usr/lib/ghc-9.0.1/site-local/tdigest-0.2.1.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/tdigest-0.2.1.1
hs-libraries:         HStdigest-0.2.1.1-K4kwzeE0H7a9LuCZaLzOci
depends:
    base-4.15.0.0 base-compat-0.11.2-EfuzzJ3SbjR74eBdJgKfBC
    binary-0.8.8.0 deepseq-1.4.5.0
    reducers-3.12.4-FtD3hvrJhaj6SpIodnf5u1
    semigroupoids-5.3.6-JFZbW6XT2Qu838ghLJLro6 transformers-0.5.6.2
    vector-0.12.3.1-HMAplmdcuCN6dtD8e6QGwL
    vector-algorithms-0.8.0.4-GADaz9rwMd2vseP5sgOfY

haddock-interfaces:   /usr/share/doc/haskell-tdigest/html/tdigest.haddock
haddock-html:         /usr/share/doc/haskell-tdigest/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

