#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 test-framework-th
version:              0.2.4
visibility:           public
id:                   test-framework-th-0.2.4-1I3ADOYlvG25q6O4S0F6SY
key:                  test-framework-th-0.2.4-1I3ADOYlvG25q6O4S0F6SY
license:              BSD-3-Clause
maintainer:           Oscar Finnsson
author:               Oscar Finnsson & Emil Nordling
homepage:             http://github.com/finnsson/test-generator
synopsis:
    Automagically generate the HUnit- and Quickcheck-bulk-code using Template Haskell.

description:
    @test-framework-th@ contains two interesting functions: @defaultMainGenerator@ and @testGroupGenerator@.

    @defaultMainGenerator@ will extract all functions beginning with case_, prop_ or test_in the module and put them in a testGroup.

    > -- file SomeModule.hs
    > ( -# LANGUAGE TemplateHaskell #- )
    > module SomeModule where
    > import Test.Framework.TH
    > import Test.Framework
    > import Test.HUnit
    > import Test.Framework.Providers.HUnit
    > import Test.Framework.Providers.QuickCheck2
    >
    > -- observe this line!
    > main = $(defaultMainGenerator)
    > case_1 = do 1 @=? 1
    > case_2 = do 2 @=? 2
    > prop_reverse xs = reverse (reverse xs) == xs
    >    where types = xs::[Int]

    is the same as

    > -- file SomeModule.hs
    > ( -# LANGUAGE TemplateHaskell #- )
    > module SomeModule where
    > import Test.Framework.TH
    > import Test.Framework
    > import Test.HUnit
    > import Test.Framework.Providers.HUnit
    > import Test.Framework.Providers.QuickCheck2
    >
    > -- observe this line!
    > main =
    >   defaultMain [
    >     testGroup "SomeModule" [ testCase "1" case_1, testCase "2" case_2, testProperty "reverse" prop_reverse]
    >     ]
    >
    > case_1 = do 1 @=? 1
    > case_2 = do 2 @=? 2
    > prop_reverse xs = reverse (reverse xs) == xs
    >    where types = xs::[Int]

    @testGroupGenerator@ is like @defaultMainGenerator@ but without @defaultMain@. It is useful if you need a function for the testgroup
    (e.g. if you want to be able to call the testgroup from another module).

category:             Testing
abi:                  d6841f0b620b2c309844f123e2288202
exposed:              True
exposed-modules:      Test.Framework.TH
import-dirs:          /usr/lib/ghc-9.0.1/site-local/test-framework-th-0.2.4
library-dirs:         /usr/lib/ghc-9.0.1/site-local/test-framework-th-0.2.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/test-framework-th-0.2.4
hs-libraries:         HStest-framework-th-0.2.4-1I3ADOYlvG25q6O4S0F6SY
depends:
    base-4.15.0.0 haskell-src-exts-1.23.1-1QZR4fKnUxdGZEJFddrirm
    language-haskell-extract-0.2.4-3QqeEJIJzmp1Ks3f97WZHN
    regex-posix-0.96.0.1-9IaC5NAq1dnF4fUYbtp0yj
    template-haskell-2.17.0.0
    test-framework-0.8.2.0-BDQIDvoiNqdFYQJQ5b4Tt

haddock-interfaces:
    /usr/share/doc/haskell-test-framework-th/html/test-framework-th.haddock

haddock-html:         /usr/share/doc/haskell-test-framework-th/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

