#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 texmath
version:              0.12.3.1
visibility:           public
id:                   texmath-0.12.3.1-9tJ2p0jEiKU1MZL1r9ZUrr
key:                  texmath-0.12.3.1-9tJ2p0jEiKU1MZL1r9ZUrr
license:              GPL-2.0-only
maintainer:           jgm@berkeley.edu
author:               John MacFarlane, Matthew Pickering
stability:            Experimental
homepage:             http://github.com/jgm/texmath
synopsis:             Conversion between formats used to represent mathematics.
description:
    The texmath library provides functions to read and
    write TeX math, presentation MathML, and OMML (Office
    Math Markup Language, used in Microsoft Office).
    Support is also included for converting math formats
    to Gnu eqn and to pandoc'\''s native format (allowing
    conversion, via pandoc, to a variety of different
    markup formats).  The TeX reader supports basic LaTeX
    and AMS extensions, and it can parse and apply LaTeX
    macros.  (See <http://johnmacfarlane.net/texmath here>
    for a live demo of bidirectional conversion between LaTeX
    and MathML.)

    The package also includes several utility modules which
    may be useful for anyone looking to manipulate either
    TeX math or MathML.  For example, a copy of the MathML
    operator dictionary is included.

    Use the @executable@ flag to install a standalone
    executable, @texmath@, that by default reads a LaTeX
    formula from @stdin@ and writes MathML to @stdout@.
    With flags all the functionality exposed by
    '\''Text.TeXMath'\'' can be accessed through this executable.
    (Use the @--help@ flag for a description of all
    functionality)

    The @texmath@ executable can also be used as a CGI
    script, when renamed as @texmath-cgi@.
    It will expect query parameters for @from@, @to@,
    @input@, and optionally @inline@, and return a JSON
    object with either @error@ and a message or
    @success@ and the converted result.

category:             Text
abi:                  04aa575f04841567f17293b807e27d7a
exposed:              True
exposed-modules:
    Text.TeXMath Text.TeXMath.Readers.MathML
    Text.TeXMath.Readers.MathML.EntityMap
    Text.TeXMath.Readers.MathML.MMLDict Text.TeXMath.Readers.OMML
    Text.TeXMath.Readers.TeX Text.TeXMath.Readers.TeX.Macros
    Text.TeXMath.TeX Text.TeXMath.Types Text.TeXMath.Unicode.Fonts
    Text.TeXMath.Unicode.ToTeX Text.TeXMath.Unicode.ToUnicode
    Text.TeXMath.Writers.Eqn Text.TeXMath.Writers.MathML
    Text.TeXMath.Writers.OMML Text.TeXMath.Writers.Pandoc
    Text.TeXMath.Writers.TeX

hidden-modules:       Text.TeXMath.Compat Text.TeXMath.Shared Paths_texmath
import-dirs:          /usr/lib/ghc-9.0.1/site-local/texmath-0.12.3.1
library-dirs:         /usr/lib/ghc-9.0.1/site-local/texmath-0.12.3.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/texmath-0.12.3.1
hs-libraries:         HStexmath-0.12.3.1-9tJ2p0jEiKU1MZL1r9ZUrr
depends:
    base-4.15.0.0 containers-0.6.4.1 mtl-2.2.2
    pandoc-types-1.22-CvHsUw0mT5oDQ6Epv01rf5 parsec-3.1.14.0
    split-0.2.3.4-BM0SHXGG6RG9udnJVWQWWX
    syb-0.7.2.1-1KAKIfi7jVfHb7rx2ko4wD text-1.2.4.1
    xml-1.3.14-21i4vhiJSXU6kuSJCTj4ZG

haddock-interfaces:   /usr/share/doc/haskell-texmath/html/texmath.haddock
haddock-html:         /usr/share/doc/haskell-texmath/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

