#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 text-show
version:              3.9.1
visibility:           public
id:                   text-show-3.9.1-FaZHv6PA3Sy8N2jVQFERyA
key:                  text-show-3.9.1-FaZHv6PA3Sy8N2jVQFERyA
license:              BSD-3-Clause
copyright:            (C) 2014-2017 Ryan Scott
maintainer:           Ryan Scott <ryan.gl.scott@gmail.com>
author:               Ryan Scott
stability:            Provisional
homepage:             https://github.com/RyanGlScott/text-show
synopsis:             Efficient conversion of values into Text
description:
    @text-show@ offers a replacement for the @Show@ typeclass intended
    for use with @Text@ instead of @String@s. This package was created
    in the spirit of
    @<http://hackage.haskell.org/package/bytestring-show bytestring-show>@.

    At the moment, @text-show@ provides instances for most data
    types in the @<http://hackage.haskell.org/package/array array>@,
    @<http://hackage.haskell.org/package/base base>@,
    @<http://hackage.haskell.org/package/bytestring bytestring>@, and
    @<http://hackage.haskell.org/package/text text>@ packages.
    Therefore, much of the source code for @text-show@ consists of
    borrowed code from those packages in order to ensure that the
    behaviors of @Show@ and @TextShow@ coincide.

    For most uses, simply importing "TextShow"
    will suffice:

    @
    module Main where

    import TextShow

    main :: IO ()
    main = printT (Just \"Hello, World!\")
    @

    See also the
    <https://github.com/RyanGlScott/text-show/wiki/Naming-conventions naming conventions>
    page.

    Support for automatically deriving @TextShow@ instances can be found
    in the "TextShow.TH" and "TextShow.Generic" modules.

category:             Text
abi:                  586886cb58f66ea28bbcde8445622355
exposed:              True
exposed-modules:
    TextShow TextShow.Control.Applicative TextShow.Control.Concurrent
    TextShow.Control.Exception TextShow.Control.Monad.ST
    TextShow.Data.Array TextShow.Data.Bool TextShow.Data.ByteString
    TextShow.Data.Char TextShow.Data.Complex TextShow.Data.Data
    TextShow.Data.Dynamic TextShow.Data.Either TextShow.Data.Fixed
    TextShow.Data.Floating TextShow.Data.Functor.Compose
    TextShow.Data.Functor.Identity TextShow.Data.Functor.Product
    TextShow.Data.Functor.Sum TextShow.Data.Integral TextShow.Data.List
    TextShow.Data.List.NonEmpty TextShow.Data.Maybe
    TextShow.Data.Monoid TextShow.Data.OldTypeable TextShow.Data.Ord
    TextShow.Data.Proxy TextShow.Data.Ratio TextShow.Data.Semigroup
    TextShow.Data.Text TextShow.Data.Tuple TextShow.Data.Type.Coercion
    TextShow.Data.Type.Equality TextShow.Data.Typeable
    TextShow.Data.Version TextShow.Data.Void TextShow.Debug.Trace
    TextShow.Debug.Trace.Generic TextShow.Debug.Trace.TH
    TextShow.Foreign.C.Types TextShow.Foreign.Ptr TextShow.Functions
    TextShow.GHC.Conc.Windows TextShow.GHC.Event
    TextShow.GHC.Fingerprint TextShow.GHC.Generics
    TextShow.GHC.RTS.Flags TextShow.GHC.Stack TextShow.GHC.StaticPtr
    TextShow.GHC.Stats TextShow.GHC.TypeLits TextShow.Generic
    TextShow.Numeric.Natural TextShow.System.Exit TextShow.System.IO
    TextShow.System.Posix.Types TextShow.TH TextShow.Text.Read

hidden-modules:
    TextShow.Classes TextShow.Data.Typeable.Utils
    TextShow.FromStringTextShow TextShow.Instances TextShow.Options
    TextShow.TH.Internal TextShow.TH.Names TextShow.Utils

import-dirs:          /usr/lib/ghc-9.0.1/site-local/text-show-3.9.1
library-dirs:         /usr/lib/ghc-9.0.1/site-local/text-show-3.9.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/text-show-3.9.1
hs-libraries:         HStext-show-3.9.1-FaZHv6PA3Sy8N2jVQFERyA
includes:             generic.h
depends:
    array-0.5.4.0 base-4.15.0.0
    base-compat-batteries-0.11.2-Cs6UiKAcT2NJzvnx9vzluN
    bifunctors-5.5.11-6LpscOqvpXFF7to3ER7bDY bytestring-0.10.12.1
    containers-0.6.4.1 generic-deriving-1.14.1-KSmOmMyINvEHBxeIVSRDRg
    ghc-boot-th-9.0.1 ghc-prim-0.7.0 integer-gmp-1.1
    template-haskell-2.17.0.0 text-1.2.4.1
    th-abstraction-0.4.3.0-DBpnRpG8EZgFebz88L1kOA
    th-lift-0.8.2-F0VVOrB5SZgFNS1AEtieR9 transformers-0.5.6.2
    transformers-compat-0.7.1-27E2wCklav6CMkj1Ns7rzE

haddock-interfaces:   /usr/share/doc/haskell-text-show/html/text-show.haddock
haddock-html:         /usr/share/doc/haskell-text-show/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

