#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 tidal
version:              1.7.8
visibility:           public
id:                   tidal-1.7.8-IsdwurpiFlM6JqXjsSSgg7
key:                  tidal-1.7.8-IsdwurpiFlM6JqXjsSSgg7
license:              GPL-3.0-only
copyright:            (c) Alex McLean and other contributors, 2021
maintainer:
    Alex McLean <alex@slab.org>, Mike Hodnick <mike.hodnick@gmail.com>

author:               Alex McLean
stability:            Experimental
homepage:             http://tidalcycles.org/
synopsis:             Pattern language for improvised music
description:
    Tidal is a domain specific language for live coding patterns.

category:             Sound
abi:                  c68ade2154a15a02a06290b24fe42512
exposed:              True
exposed-modules:
    Paths_tidal Sound.Tidal.Bjorklund Sound.Tidal.Carabiner
    Sound.Tidal.Chords Sound.Tidal.Config Sound.Tidal.Context
    Sound.Tidal.Control Sound.Tidal.Core Sound.Tidal.EspGrid
    Sound.Tidal.Params Sound.Tidal.ParseBP Sound.Tidal.Pattern
    Sound.Tidal.Scales Sound.Tidal.Show Sound.Tidal.Simple
    Sound.Tidal.Stream Sound.Tidal.Tempo Sound.Tidal.Time
    Sound.Tidal.Transition Sound.Tidal.UI Sound.Tidal.Utils
    Sound.Tidal.Version

import-dirs:          /usr/lib/ghc-9.0.1/site-local/tidal-1.7.8
library-dirs:         /usr/lib/ghc-9.0.1/site-local/tidal-1.7.8
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/tidal-1.7.8
hs-libraries:         HStidal-1.7.8-IsdwurpiFlM6JqXjsSSgg7
depends:
    base-4.15.0.0 bifunctors-5.5.11-6LpscOqvpXFF7to3ER7bDY
    bytestring-0.10.12.1 clock-0.8.2-FEbX8RY0vheCS7qJJxWpPc
    colour-2.3.6-INQpyJrfu244Q1q0HWiHAI containers-0.6.4.1
    deepseq-1.4.5.0 hosc-0.19.1-Anzvs7wj7741pZnlIrcdXx
    network-3.1.2.2-HXcjy5szECnDN1PS9jNchP parsec-3.1.14.0
    primitive-0.7.2.0-H9HP2FbaY5C1JlRHDKja9P
    random-1.2.1-Iy7yOfCz74T6VyvkhFUFfX text-1.2.4.1
    transformers-0.5.6.2

haddock-interfaces:   /usr/share/doc/haskell-tidal/html/tidal.haddock
haddock-html:         /usr/share/doc/haskell-tidal/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

