#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 tree-diff
version:              0.2.1
visibility:           public
id:                   tree-diff-0.2.1-39EvRUEEzIz3y2K7r94d10
key:                  tree-diff-0.2.1-39EvRUEEzIz3y2K7r94d10
license:              GPL-2.0-or-later
copyright:            (c) 2017-2021 Oleg Grenrus
maintainer:           Oleg.Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/tree-diff
synopsis:             Diffing of (expression) trees.
description:
    Common diff algorithm works on list structures:

    @
    diff :: Eq a => [a] -> [a] -> [Edit a]
    @

    This package works on trees.

    @
    treeDiff :: Eq a => Tree a -> Tree a -> Edit (EditTree a)
    @

    This package also provides a way to diff arbitrary ADTs,
    using @Generics@-derivable helpers.

    This package differs from <http://hackage.haskell.org/package/gdiff gdiff>,
    in a two ways: @tree-diff@ doesn'\''t have patch function,
    and the "edit-script" is a tree itself, which is useful for pretty-printing.

    @
    >>> prettyEditExpr $ ediff (Foo 42 [True, False] "old") (Foo 42 [False, False, True] "new")
    Foo
    \  {fooBool = [-True, +False, False, +True],
    \   fooInt = 42,
    \   fooString = -"old" +"new"}
    @

category:             Data, Testing
abi:                  6d1d2cb9a7755efdfa1c821e1c882787
exposed:              True
exposed-modules:
    Data.TreeDiff Data.TreeDiff.Class Data.TreeDiff.Expr
    Data.TreeDiff.Golden Data.TreeDiff.List Data.TreeDiff.OMap
    Data.TreeDiff.Parser Data.TreeDiff.Pretty Data.TreeDiff.QuickCheck
    Data.TreeDiff.Tree

import-dirs:          /usr/lib/ghc-9.0.1/site-local/tree-diff-0.2.1
library-dirs:         /usr/lib/ghc-9.0.1/site-local/tree-diff-0.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/tree-diff-0.2.1
hs-libraries:         HStree-diff-0.2.1-39EvRUEEzIz3y2K7r94d10
depends:
    QuickCheck-2.14.2-3f9Gw3UEGqTK3AyHIcW3dz
    aeson-1.5.6.0-FZsVpvEwT8z4bK1D26EwAs
    ansi-terminal-0.11-DOUngjGM5e9DBdxKKdJoVq
    ansi-wl-pprint-0.6.9-BXMgVftyT2QAgtHXr6JIlm base-4.15.0.0
    base-compat-0.11.2-EfuzzJ3SbjR74eBdJgKfBC bytestring-0.10.12.1
    containers-0.6.4.1 deepseq-1.4.5.0
    hashable-1.3.4.0-IEtvls2JnYMCj5AtMjw8bF parsec-3.1.14.0
    parsers-0.12.10-KaMcg7JHxkC3cA5DWkZtNc pretty-1.1.3.6
    primitive-0.7.2.0-H9HP2FbaY5C1JlRHDKja9P
    scientific-0.3.7.0-80Xt5iXHAGIBd7njyVx1yZ
    semialign-1.2-8QfQlh7gvdCEsYbCM2cR4M
    strict-0.4.0.1-1mB9RKQBFAgAU2HlDWOyE6
    tagged-0.8.6.1-FL843C40q4d1DeuwYADr25 text-1.2.4.1
    these-1.1.1.1-AybLjjHc0wbCr4q1AKL8Rf time-1.9.3
    unordered-containers-0.2.14.0-7Twq3Q78XsnAV2eREMKYwX
    uuid-types-1.0.5-DnTMkFEZqWsJHlKreHQipp
    vector-0.12.3.1-HMAplmdcuCN6dtD8e6QGwL

haddock-interfaces:   /usr/share/doc/haskell-tree-diff/html/tree-diff.haddock
haddock-html:         /usr/share/doc/haskell-tree-diff/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

