#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 trifecta
version:              2.1.1
visibility:           public
id:                   trifecta-2.1.1-AqfihMPjaSeAZQt2J0vbZG
key:                  trifecta-2.1.1-AqfihMPjaSeAZQt2J0vbZG
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  a93e720059d16766044c6b0cbbb9ec73
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.0.1/site-local/trifecta-2.1.1
library-dirs:         /usr/lib/ghc-9.0.1/site-local/trifecta-2.1.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/trifecta-2.1.1
hs-libraries:         HStrifecta-2.1.1-AqfihMPjaSeAZQt2J0vbZG
depends:
    ansi-terminal-0.11-DOUngjGM5e9DBdxKKdJoVq array-0.5.4.0
    base-4.15.0.0 blaze-builder-0.4.2.2-Iw4q9HoGXXULmCBD2udQGP
    blaze-html-0.9.1.2-KB0lS4ujoOZB0BWG67YZVZ
    blaze-markup-0.8.2.8-8PH9vh1UAZb2ZrMELNvjH9 bytestring-0.10.12.1
    charset-0.3.9-7AQXNxfVN2nHTe8YVPxF46
    comonad-5.0.8-AsllVmCbjpcHyD8OOCrv5S containers-0.6.4.1
    deepseq-1.4.5.0 fingertree-0.1.4.2-9J2gUWTCQY5GuREJSkXzUp
    ghc-prim-0.7.0 hashable-1.3.4.0-IEtvls2JnYMCj5AtMjw8bF
    indexed-traversable-0.1.1-K0YsJRCif6Q7nMYcYE7GvA
    lens-5.0.1-E7Tul8EWHuqGCOW8gNOuPe mtl-2.2.2
    parsers-0.12.10-KaMcg7JHxkC3cA5DWkZtNc
    prettyprinter-1.7.1-Cr9OhaeuhZG9wS7WBggFWd
    prettyprinter-ansi-terminal-1.1.3-56brpgZIyjX2iwvXfjkCBe
    profunctors-5.6.2-JSpjDLFOHziFMPQ6l5NowS
    reducers-3.12.4-FtD3hvrJhaj6SpIodnf5u1 transformers-0.5.6.2
    unordered-containers-0.2.14.0-7Twq3Q78XsnAV2eREMKYwX
    utf8-string-1.0.2-FSV4F6pxd5y7PjtRkbEpDf

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

