#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 turtle
version:              1.5.22
visibility:           public
id:                   turtle-1.5.22-94kZOzW5RwNEcKRzAbFls5
key:                  turtle-1.5.22-94kZOzW5RwNEcKRzAbFls5
license:              BSD-3-Clause
copyright:            2015 Gabriel Gonzalez
maintainer:           Gabriel439@gmail.com
author:               Gabriel Gonzalez
synopsis:             Shell programming, Haskell-style
description:
    @turtle@ is a reimplementation of the Unix command line environment
    in Haskell so that you can use Haskell as both a shell and a scripting
    language.

    Features include:

    * Batteries included: Command an extended suite of predefined utilities

    * Interoperability: You can still run external shell commands

    * Portability: Works on Windows, OS X, and Linux

    * Exception safety: Safely acquire and release resources

    * Streaming: Transform or fold command output in constant space

    * Patterns: Use typed regular expressions that can parse structured values

    * Formatting: Type-safe @printf@-style text formatting

    * Modern: Supports @text@ and @system-filepath@

    Read "Turtle.Tutorial" for a detailed tutorial or "Turtle.Prelude" for a
    quick-start guide

    @turtle@ is designed to be beginner-friendly, but as a result lacks certain
    features, like tracing commands.  If you feel comfortable using @turtle@
    then you should also check out the @Shelly@ library which provides similar
    functionality.

category:             System
abi:                  21c816e467adee9784688accdb033975
exposed:              True
exposed-modules:
    Turtle Turtle.Bytes Turtle.Format Turtle.Line Turtle.Options
    Turtle.Pattern Turtle.Prelude Turtle.Shell Turtle.Tutorial

hidden-modules:       Turtle.Internal
import-dirs:          /usr/lib/ghc-9.0.1/site-local/turtle-1.5.22
library-dirs:         /usr/lib/ghc-9.0.1/site-local/turtle-1.5.22
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/turtle-1.5.22
hs-libraries:         HSturtle-1.5.22-94kZOzW5RwNEcKRzAbFls5
depends:
    ansi-wl-pprint-0.6.9-BXMgVftyT2QAgtHXr6JIlm
    async-2.2.3-9hcO3XZAP863cAPa5inA8N base-4.15.0.0
    bytestring-0.10.12.1 clock-0.8.2-FEbX8RY0vheCS7qJJxWpPc
    containers-0.6.4.1 directory-1.3.6.1 exceptions-0.10.4
    foldl-1.4.12-2EVLzEVGzpR6wEZczao2HX
    hostname-1.0-Br1jPZ1TQM2JEvPBDCu2td
    managed-1.0.8-Iqn2ptQzPuu7QP28Paeyua
    optional-args-1.0.2-J6idpveIpeZKXcSO6sqXCb
    optparse-applicative-0.16.1.0-Hmp4enGFORO7G3xu1QJ5as
    process-1.6.11.0 stm-2.5.0.0
    streaming-commons-0.2.2.1-8n8dllyBp1F12Lm7Sqc21T
    system-fileio-0.3.16.4-LG9aVHBL9PL1bR2JHGIIkj
    system-filepath-0.4.14-FwdvP4HSweFzGesp7eRlh
    temporary-1.3-6FIxg0ZrJD07j9FbKd9D73 text-1.2.4.1 time-1.9.3
    transformers-0.5.6.2 unix-2.7.2.2
    unix-compat-0.5.3-CsWJk3UHZrh7lbWn5tdOhn

haddock-interfaces:   /usr/share/doc/haskell-turtle/html/turtle.haddock
haddock-html:         /usr/share/doc/haskell-turtle/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

